/*
 * Decompiled with CFR 0.152.
 */
package com.biomemusic.mixin;

import com.biomemusic.AdditionalMusic;
import com.biomemusic.BiomeMusic;
import com.biomemusic.config.CommonConfiguration;
import com.biomemusic.environment.MusicEnvironment;
import com.biomemusic.environment.MusicType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class}, priority=5)
public abstract class ClientMusicChoiceMixin {
    @Shadow
    @Nullable
    public Screen screen;
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Final
    public Gui gui;

    @Shadow
    public abstract MusicManager getMusicManager();

    @Inject(method={"getSituationalMusic"}, at={@At(value="HEAD")}, cancellable=true)
    private void biomemusic$musicChoice(CallbackInfoReturnable<Music> cir) {
        if (this.screen instanceof WinScreen) {
            return;
        }
        Music music = (Music)Optionull.map((Object)this.screen, Screen::getBackgroundMusic);
        if (music != null) {
            cir.setReturnValue((Object)music);
            return;
        }
        if (this.player == null) {
            if (BiomeMusic.rand.nextInt(10) == 0 && !AdditionalMusic.DISABLED.contains(AdditionalMusic.MENU_ADDITIONAL)) {
                cir.setReturnValue((Object)AdditionalMusic.MENU_ADDITIONAL);
            } else {
                cir.setReturnValue((Object)Musics.MENU);
            }
            return;
        }
        ArrayList<Music> possibleTracks = new ArrayList<Music>();
        if (this.player.getY() < (double)this.player.level().getSeaLevel() && !this.player.level().canSeeSky(this.player.blockPosition())) {
            if (this.player.level().getBrightness(LightLayer.BLOCK, this.player.blockPosition()) < 6 && !this.player.isUnderWater()) {
                ++AdditionalMusic.CAVE_TICKS;
            }
        } else {
            AdditionalMusic.CAVE_TICKS = 0;
        }
        boolean envChanged = false;
        envChanged |= MusicEnvironment.setEnvironmentFor(MusicEnvironment.END, this.player.level().dimension() == Level.END);
        envChanged |= MusicEnvironment.setEnvironmentFor(MusicEnvironment.NETHER, this.player.level().dimension() == Level.NETHER);
        envChanged |= MusicEnvironment.setEnvironmentFor(MusicEnvironment.OVERWORLD, this.player.level().dimension() == Level.OVERWORLD);
        envChanged |= MusicEnvironment.setEnvironmentFor(MusicEnvironment.OTHERDIMENSIONS, this.player.level().dimension() != Level.END && this.player.level().dimension() != Level.NETHER && this.player.level().dimension() != Level.OVERWORLD);
        envChanged |= MusicEnvironment.setEnvironmentFor(MusicEnvironment.CAVE, AdditionalMusic.CAVE_TICKS > 300);
        envChanged |= MusicEnvironment.setEnvironmentFor(MusicEnvironment.NIGHT, this.player.level().dimensionType().hasSkyLight() && !this.player.level().dimensionType().hasFixedTime() && this.player.level().getDayTime() % 24000L > 12600L);
        if (this.player.isUnderWater() && this.player.level().getBiome(this.player.blockPosition()).is(BiomeTags.PLAYS_UNDERWATER_MUSIC)) {
            envChanged |= MusicEnvironment.setEnvironmentFor(MusicEnvironment.WATER, true);
            AdditionalMusic.CAVE_TICKS = 0;
        } else {
            envChanged |= MusicEnvironment.setEnvironmentFor(MusicEnvironment.WATER, false);
        }
        if (envChanged) {
            this.getMusicManager().nextSongDelay /= 2;
        }
        if (MusicEnvironment.canPlay(MusicType.End)) {
            if (this.gui.getBossOverlay().shouldPlayMusic()) {
                possibleTracks.add(Musics.END_BOSS);
            } else {
                possibleTracks.add(Musics.END);
            }
            possibleTracks.add(AdditionalMusic.END_ADDITIONAL);
            possibleTracks.add(AdditionalMusic.END_ADDITIONAL);
        }
        if (MusicEnvironment.canPlay(MusicType.Nether)) {
            possibleTracks.add(AdditionalMusic.NETHER_ALL);
            possibleTracks.add(AdditionalMusic.NETHER_ALL);
        }
        if (MusicEnvironment.canPlay(MusicType.Night)) {
            possibleTracks.add(AdditionalMusic.NIGHT_ADDITIONAL);
            possibleTracks.add(AdditionalMusic.NIGHT_ADDITIONAL);
        }
        if (MusicEnvironment.canPlay(MusicType.Cave)) {
            possibleTracks.add(AdditionalMusic.CAVE_ADDITIONAL);
            possibleTracks.add(AdditionalMusic.CAVE_ADDITIONAL);
            possibleTracks.add(AdditionalMusic.CAVE_ADDITIONAL);
            possibleTracks.add(AdditionalMusic.CAVE_ADDITIONAL);
            possibleTracks.add(AdditionalMusic.CAVE_ADDITIONAL);
            possibleTracks.add(AdditionalMusic.CAVE_ADDITIONAL);
        }
        if (MusicEnvironment.canPlay(MusicType.Game)) {
            if (this.player.isCreative()) {
                possibleTracks.add(Musics.CREATIVE);
            }
            possibleTracks.add(Musics.GAME);
            possibleTracks.add(Musics.GAME);
            possibleTracks.add(AdditionalMusic.GAME_ADDITIONAL);
            possibleTracks.add(AdditionalMusic.GAME_ADDITIONAL);
        }
        if (MusicEnvironment.canPlay(MusicType.Water)) {
            possibleTracks.add(Musics.UNDER_WATER);
            possibleTracks.add(Musics.UNDER_WATER);
            possibleTracks.add(Musics.UNDER_WATER);
            possibleTracks.add(AdditionalMusic.WATER_ADDITIONAL);
            possibleTracks.add(AdditionalMusic.WATER_ADDITIONAL);
        }
        if (MusicEnvironment.canPlay(MusicType.Biome)) {
            Holder holder = this.player.level().getBiome(this.player.blockPosition());
            Music biomeMusic = ((Biome)holder.value()).getBackgroundMusic().orElse(null);
            if (biomeMusic != null) {
                possibleTracks.add(biomeMusic);
                possibleTracks.add(biomeMusic);
                possibleTracks.add(biomeMusic);
                possibleTracks.add(biomeMusic);
                possibleTracks.add(biomeMusic);
            }
            if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).musicVariance) {
                for (Map.Entry<TagKey<Biome>, List<Music>> entry : AdditionalMusic.taggedMusic.entrySet()) {
                    if (!holder.is(entry.getKey())) continue;
                    possibleTracks.addAll((Collection)entry.getValue());
                    possibleTracks.addAll((Collection)entry.getValue());
                }
                for (Map.Entry<Object, List<Music>> entry : AdditionalMusic.namedMusic.entrySet()) {
                    if (!holder.unwrapKey().isPresent() || !((ResourceKey)holder.unwrapKey().get()).location().getPath().contains((CharSequence)entry.getKey())) continue;
                    possibleTracks.addAll((Collection)entry.getValue());
                    possibleTracks.addAll((Collection)entry.getValue());
                }
            }
        }
        Iterator iterator = possibleTracks.iterator();
        while (iterator.hasNext()) {
            Music track = (Music)iterator.next();
            if (!AdditionalMusic.DISABLED.contains(track)) continue;
            iterator.remove();
        }
        if (possibleTracks.isEmpty()) {
            return;
        }
        cir.setReturnValue((Object)((Music)possibleTracks.get(BiomeMusic.rand.nextInt(possibleTracks.size()))));
    }
}

