/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.habitats;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dmr.DragonMounts.types.habitats.Habitat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;

public record FluidHabitat(float multiplier, TagKey<Fluid> fluidType) implements Habitat
{
    public static final Codec<FluidHabitat> CODEC = RecordCodecBuilder.create(instance -> instance.group(Habitat.withMultiplier(0.5f, FluidHabitat::multiplier), (App)TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("fluid_tag").forGetter(FluidHabitat::fluidType)).apply((Applicative)instance, FluidHabitat::new));

    @Override
    public int getHabitatPoints(Level level, BlockPos pos) {
        return (int)((float)BlockPos.betweenClosedStream((BlockPos)pos.offset(1, 1, 1), (BlockPos)pos.offset(-1, -1, -1)).filter(p -> level.getFluidState(p).is(this.fluidType)).count() * this.multiplier);
    }

    @Override
    public String type() {
        return Habitat.IN_FLUID;
    }
}

