/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.habitats;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dmr.DragonMounts.types.habitats.Habitat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public record BiomeHabitat(int points, TagKey<Biome> biomeTag) implements Habitat
{
    public static final Codec<BiomeHabitat> CODEC = RecordCodecBuilder.create(instance -> instance.group(Habitat.withPoints(3, BiomeHabitat::points), (App)TagKey.codec((ResourceKey)Registries.BIOME).fieldOf("biome_tag").forGetter(BiomeHabitat::biomeTag)).apply((Applicative)instance, BiomeHabitat::new));

    @Override
    public int getHabitatPoints(Level level, BlockPos pos) {
        return level.getBiome(pos).is(this.biomeTag) ? this.points : 0;
    }

    @Override
    public String type() {
        return Habitat.BIOMES;
    }
}

