/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;

public class ResourcePackLoader {
    public static HashMap<String, List<String>> modelProperties = new HashMap();
    public static HashMap<String, List<String>> negativeModelProperties = new HashMap();

    public static void addModelProperty(String key, List<String> bones, List<String> negativeBones) {
        modelProperties.put(key, bones);
        if (negativeBones != null && negativeBones.size() > 0) {
            negativeModelProperties.put(key, negativeBones);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addReloadListener(FMLClientSetupEvent event) {
        ResourcePackLoader.reload(Minecraft.getInstance().getResourceManager());
        if (Minecraft.getInstance().getResourceManager() instanceof ReloadableResourceManager) {
            ((ReloadableResourceManager)Minecraft.getInstance().getResourceManager()).registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> ResourcePackLoader.reload(Minecraft.getInstance().getResourceManager())));
        }
    }

    protected static void reload(ResourceManager manager) {
        Gson gson = new Gson();
        modelProperties.clear();
        negativeModelProperties.clear();
        Map accessoryResources = manager.listResources("accessories", s -> s.getPath().endsWith(".json"));
        for (Map.Entry entry : accessoryResources.entrySet()) {
            try {
                Resource resource = (Resource)entry.getValue();
                BufferedReader reader = resource.openAsReader();
                try {
                    AccessoryJson accessoryJson = (AccessoryJson)gson.fromJson((Reader)reader, AccessoryJson.class);
                    if (accessoryJson.bones == null) continue;
                    String key = ((ResourceLocation)entry.getKey()).getPath().replace(".json", "");
                    key = key.substring(key.lastIndexOf("/") + 1);
                    ResourcePackLoader.addModelProperty(key, accessoryJson.bones, accessoryJson.negativeBones);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class AccessoryJson {
        public List<String> bones = new ArrayList<String>();
        public List<String> negativeBones = new ArrayList<String>();

        AccessoryJson() {
        }
    }
}

