/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.items;

import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModBlocks;
import dmr.DragonMounts.registry.ModComponents;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.types.dragonBreeds.DragonBreed;
import dmr.DragonMounts.types.dragonBreeds.DragonHybridBreed;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class DragonEggItemBlock
extends BlockItem {
    public DragonEggItemBlock(Item.Properties pProperties) {
        super((Block)ModBlocks.DRAGON_EGG_BLOCK.get(), pProperties.rarity(Rarity.EPIC));
    }

    public static ItemStack getDragonEggStack(IDragonBreed type) {
        return DragonEggItemBlock.getDragonEggStack(type, 1, null);
    }

    public static ItemStack getDragonEggStack(IDragonBreed type, IDragonBreed.Variant variant) {
        return DragonEggItemBlock.getDragonEggStack(type, 1, variant);
    }

    public static ItemStack getDragonEggStack(IDragonBreed type, int count, IDragonBreed.Variant variant) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.DRAGON_EGG_BLOCK_ITEM.get(), count);
        if (variant != null) {
            DragonBreed.setDragonTypeVariant(stack, type, variant);
        } else {
            DragonBreed.setDragonType(stack, type);
        }
        return stack;
    }

    public String getDescriptionId(ItemStack pStack) {
        String breed = (String)pStack.get(ModComponents.DRAGON_BREED);
        String variant = (String)pStack.get(ModComponents.DRAGON_VARIANT);
        if (breed == null) {
            return "item.dmr.dragon_egg.deprecated";
        }
        return String.join((CharSequence)".", ModBlocks.DRAGON_EGG_BLOCK.get().getDescriptionId(), breed + (String)(variant != null ? "$" + variant : ""));
    }

    public Component getName(ItemStack pStack) {
        IDragonBreed breed = DragonBreed.getDragonType(pStack);
        if (breed instanceof DragonHybridBreed) {
            DragonHybridBreed hybridBreed = (DragonHybridBreed)breed;
            String par1 = hybridBreed.parent1.getName().getString();
            String par2 = hybridBreed.parent2.getName().getString();
            String langKey = String.join((CharSequence)".", ModBlocks.DRAGON_EGG_BLOCK.get().getDescriptionId(), "hybrid");
            return Component.translatable((String)langKey, (Object[])new Object[]{par1, par2});
        }
        return super.getName(pStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag pFlag) {
        super.appendHoverText(stack, context, tooltips, pFlag);
        String breedId = (String)stack.get(ModComponents.DRAGON_BREED);
        if (breedId == null) {
            tooltips.add((Component)Component.translatable((String)"item.dmr.dragon_egg.deprecated.tooltip").withStyle(ChatFormatting.GRAY));
            return;
        }
        int hatchTime = (Integer)stack.getOrDefault(ModComponents.EGG_HATCH_TIME, (Object)0);
        IDragonBreed breed = DragonBreedsRegistry.getDragonBreed(breedId);
        if (breed != null && hatchTime != 0 && hatchTime != breed.getHatchTime()) {
            int minutes = hatchTime / 60;
            int seconds = hatchTime % 60;
            String time = String.format("%d:%02d", minutes, seconds);
            tooltips.add((Component)Component.translatable((String)(this.getDescriptionId() + ".hatch_time_tooltip"), (Object[])new Object[]{time}).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD));
        }
        tooltips.add((Component)Component.translatable((String)"item.dmr.dragon_egg.hatch_tooltip").withStyle(ChatFormatting.GRAY));
    }
}

