/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.ai.behaviours;

import dmr.DragonMounts.server.entity.TameableDragonEntity;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.goal.Goal;

public class GoalWrapper
implements BehaviorControl<TameableDragonEntity> {
    private Behavior.Status status = Behavior.Status.STOPPED;
    private Goal goal;
    private final Function<TameableDragonEntity, Goal> goalSupplier;
    private final boolean clearSitting;

    public GoalWrapper(Function<TameableDragonEntity, Goal> goalSupplier) {
        this(goalSupplier, false);
    }

    public GoalWrapper(Function<TameableDragonEntity, Goal> goalSupplier, boolean clearSitting) {
        this.goalSupplier = goalSupplier;
        this.clearSitting = clearSitting;
    }

    public Behavior.Status getStatus() {
        return this.status;
    }

    public boolean tryStart(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        if (this.goal == null) {
            this.goal = this.goalSupplier.apply(entity);
        }
        if (this.goal.canUse()) {
            this.status = Behavior.Status.RUNNING;
            if (this.clearSitting) {
                entity.stopSitting();
            }
            this.goal.start();
            return true;
        }
        return false;
    }

    public void tickOrStop(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        this.goal.tick();
        if (!this.goal.canContinueToUse()) {
            this.doStop(level, entity, gameTime);
        }
    }

    public void doStop(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        this.goal.stop();
        this.status = Behavior.Status.STOPPED;
    }

    public String debugString() {
        return this.goal.getClass().getSimpleName();
    }
}

