/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.registry.ModActivityTypes;
import dmr.DragonMounts.registry.ModEntities;
import dmr.DragonMounts.registry.ModMemoryModuleTypes;
import dmr.DragonMounts.registry.ModSensors;
import dmr.DragonMounts.server.ai.behaviours.BehaviorFactory;
import dmr.DragonMounts.server.ai.behaviours.ChangeIdleTimer;
import dmr.DragonMounts.server.ai.behaviours.DragonBreathAttack;
import dmr.DragonMounts.server.ai.behaviours.DragonBreedBehaviour;
import dmr.DragonMounts.server.ai.behaviours.ForceSitting;
import dmr.DragonMounts.server.ai.behaviours.RandomSitting;
import dmr.DragonMounts.server.entity.DragonAgroState;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.GlobalPos;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StayCloseToTarget;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.schedule.Activity;

public class DragonAI {
    private static final List<MemoryModuleType<?>> MEMORY_MODULES = ImmutableList.of((Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object[])new MemoryModuleType[]{MemoryModuleType.PATH, MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_VISIBLE_ADULT, ModMemoryModuleTypes.SHOULD_SIT.get(), ModMemoryModuleTypes.SHOULD_WANDER.get(), ModMemoryModuleTypes.IDLE_TICKS.get(), ModMemoryModuleTypes.HAS_BREATH_COOLDOWN.get()});
    private static final Collection<? extends SensorType<? extends Sensor<? super LivingEntity>>> SENSORS = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_PLAYERS, ModSensors.DRAGON_ATTACKABLES.get());
    private static final float SWIM_SPEED = 0.8f;
    private static final float WALK_SPEED = 1.0f;
    private static final float ATTACK_SPEED = 2.0f;
    private static final float BREED_SPEED = 1.2f;
    private static final float FOLLOW_SPEED = 1.2f;
    private static final float WANDER_SPEED = 1.0f;
    private static final int IDLE_TIMEOUT = 200;
    private static final int MIN_WANDER_DISTANCE = 2;
    private static final int MAX_WANDER_DISTANCE = 32;
    private static final int BREED_DETECTION_RANGE = 6;
    private static final int MELEE_ATTACK_COOLDOWN = 10;
    private static final int RETALIATION_DISTANCE_CHECK = 4;
    private static final float PLAYER_LOOK_DISTANCE = 6.0f;
    private static final int LOOK_INTERVAL_MIN = 400;
    private static final int LOOK_INTERVAL_MAX = 800;
    private static final int RANDOM_LOOK_INTERVAL_MIN = 150;
    private static final int RANDOM_LOOK_INTERVAL_MAX = 250;
    private static final float RANDOM_LOOK_HORIZONTAL_ANGLE = 30.0f;
    private static final float RANDOM_LOOK_VERTICAL_ANGLE_MIN = 0.0f;
    private static final float RANDOM_LOOK_VERTICAL_ANGLE_MAX = 0.0f;
    private static final int RANDOM_SIT_MIN_DURATION = 100;
    private static final int RANDOM_SIT_MAX_DURATION = 200;
    private static final int IDLE_DO_NOTHING_MIN_DURATION = 10;
    private static final int IDLE_DO_NOTHING_MAX_DURATION = 200;

    public static Brain.Provider<TameableDragonEntity> brainProvider() {
        return Brain.provider(MEMORY_MODULES, SENSORS);
    }

    public static Brain<?> makeBrain(Brain<TameableDragonEntity> brain) {
        DragonAI.initCoreActivity(brain);
        DragonAI.initIdleActivity(brain);
        DragonAI.initFightActivity(brain);
        DragonAI.initSitActivity(brain);
        DragonAI.initWanderActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<TameableDragonEntity> brain) {
        ImmutableList coreBehaviors = ImmutableList.of((Object)new Swim(0.8f), DragonAI.createLookAtTargetBehavior(), DragonAI.createRandomLookBehavior(), DragonAI.createMoveToTargetBehavior());
        brain.addActivity(Activity.CORE, 0, coreBehaviors);
    }

    private static void initIdleActivity(Brain<TameableDragonEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, DragonAI.createBreedingBehavior()), (Object)Pair.of((Object)0, DragonAI.createTargetAcquisitionBehavior()), (Object)Pair.of((Object)1, DragonAI.createAttackInitiationBehavior()), (Object)Pair.of((Object)0, DragonAI.createOwnerFollowingBehavior()), (Object)Pair.of((Object)4, DragonAI.createIdleMovementBehavior()), (Object)Pair.of((Object)10, (Object)new ChangeIdleTimer(ChangeIdleTimer.ChangeType.INCREASE, 1))));
    }

    private static void initFightActivity(Brain<TameableDragonEntity> brain) {
        ImmutableList fightBehaviors = ImmutableList.of(DragonAI.createBreathAttackBehavior(), DragonAI.createMeleeAttackBehavior(), (Object)StopAttackingIfTargetInvalid.create(), (Object)EraseMemoryIf.create(BehaviorUtils::isBreeding, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET));
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 0, fightBehaviors, MemoryModuleType.ATTACK_TARGET);
    }

    private static void initSitActivity(Brain<TameableDragonEntity> brain) {
        brain.addActivityWithConditions(ModActivityTypes.SIT.get(), ImmutableList.of((Object)Pair.of((Object)0, DragonAI.createSittingBehavior())), (Set)ImmutableSet.of((Object)Pair.of(ModMemoryModuleTypes.SHOULD_SIT.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initWanderActivity(Brain<TameableDragonEntity> brain) {
        brain.addActivityWithConditions(ModActivityTypes.WANDER.get(), ImmutableList.of((Object)Pair.of((Object)0, DragonAI.createWanderingBehavior())), (Set)ImmutableSet.of((Object)Pair.of(ModMemoryModuleTypes.SHOULD_SIT.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(ModMemoryModuleTypes.SHOULD_WANDER.get(), (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static BehaviorControl<TameableDragonEntity> createLookAtTargetBehavior() {
        return BehaviorFactory.withMemoryRequirements(ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), new BehaviorControl[]{new LookAtTargetSink(45, 90)});
    }

    private static BehaviorControl<TameableDragonEntity> createRandomLookBehavior() {
        return BehaviorFactory.withMemoryRequirements(ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), new BehaviorControl[]{SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)400, (int)800)), new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)});
    }

    private static BehaviorControl<TameableDragonEntity> createMoveToTargetBehavior() {
        return BehaviorFactory.withConditionAndMemory(DragonAI::shouldMoveToTarget, ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), new BehaviorControl[]{new MoveToTargetSink()});
    }

    private static BehaviorControl<TameableDragonEntity> createBreedingBehavior() {
        return BehaviorFactory.withCondition(Animal::isInLove, new BehaviorControl[]{new DragonBreedBehaviour(ModEntities.DRAGON_ENTITY.get(), 1.2f, 6)});
    }

    private static BehaviorControl<TameableDragonEntity> createTargetAcquisitionBehavior() {
        return BehaviorFactory.withCondition(dr -> dr.isTame() && dr.getAgroState() != DragonAgroState.PASSIVE, BehaviorFactory.withGoals(e -> true, OwnerHurtByTargetGoal::new, OwnerHurtTargetGoal::new, x$0 -> new HurtByTargetGoal(x$0, new Class[0])));
    }

    private static BehaviorControl<TameableDragonEntity> createAttackInitiationBehavior() {
        return BehaviorFactory.withCondition(e -> !e.isSitting() && e.getAgroState() != DragonAgroState.PASSIVE, StartAttacking.create(DragonAI::findNearestValidAttackTarget));
    }

    private static BehaviorControl<TameableDragonEntity> createOwnerFollowingBehavior() {
        return BehaviorFactory.withCondition(DragonAI::shouldFollowOwner, StayCloseToTarget.create(DragonAI::getOwnerPosition, e -> true, (int)ServerConfig.MIN_FOLLOW_DISTANCE, (int)ServerConfig.MAX_FOLLOW_DISTANCE, (float)1.2f));
    }

    private static BehaviorControl<TameableDragonEntity> createIdleMovementBehavior() {
        return BehaviorFactory.withConditionAndMemory(DragonAI::shouldPerformIdleBehavior, ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), new BehaviorControl[]{RandomStroll.stroll((float)1.0f), RandomStroll.swim((float)1.0f), new RandomSitting(100, 200), new DoNothing(10, 200)});
    }

    private static BehaviorControl<TameableDragonEntity> createBreathAttackBehavior() {
        return new DragonBreathAttack();
    }

    private static BehaviorControl<TameableDragonEntity> createMeleeAttackBehavior() {
        return BehaviorFactory.withMemoryRequirements(ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, ModMemoryModuleTypes.HAS_BREATH_COOLDOWN.get(), (Object)MemoryStatus.VALUE_PRESENT), new BehaviorControl[]{SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)2.0f), MeleeAttack.create((int)10)});
    }

    private static BehaviorControl<TameableDragonEntity> createSittingBehavior() {
        return BehaviorFactory.withCondition(e -> true, BehaviorFactory.withPolicies(e -> true, GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, new ChangeIdleTimer(ChangeIdleTimer.ChangeType.SET, 0), new ForceSitting()));
    }

    private static BehaviorControl<TameableDragonEntity> createWanderingBehavior() {
        return BehaviorFactory.withCondition(e -> e.hasWanderTarget() && !e.isSitting(), StayCloseToTarget.create(DragonAI::getWanderTarget, e -> true, (int)2, (int)32, (float)1.0f), BehaviorFactory.withMemoryRequirements(ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), new BehaviorControl[]{RandomStroll.stroll((float)1.0f, (int)32, (int)1), new RandomSitting(100, 200), new DoNothing(10, 200)}));
    }

    private static boolean shouldMoveToTarget(LivingEntity entity) {
        if (!(entity instanceof TameableDragonEntity)) {
            return true;
        }
        TameableDragonEntity dragon = (TameableDragonEntity)entity;
        boolean isRandomlySitting = dragon.isRandomlySitting();
        boolean isBreeding = dragon.isInLove() && dragon.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET);
        return !isRandomlySitting || isBreeding;
    }

    private static boolean shouldFollowOwner(LivingEntity entity) {
        if (!(entity instanceof TameableDragonEntity)) {
            return false;
        }
        TameableDragonEntity dragon = (TameableDragonEntity)entity;
        boolean isTamed = dragon.isTame();
        boolean isNotSitting = !dragon.isOrderedToSit();
        boolean hasNoWanderTarget = !dragon.hasWanderTarget();
        return isTamed && isNotSitting && hasNoWanderTarget;
    }

    private static boolean shouldPerformIdleBehavior(TameableDragonEntity dragon) {
        boolean isIdleTimeoutReached = dragon.getBrain().getMemory(ModMemoryModuleTypes.IDLE_TICKS.get()).orElse(0) >= 200;
        boolean isUntamed = !dragon.isTame();
        boolean isNotSitting = !dragon.isSitting();
        return (isUntamed || isIdleTimeoutReached) && isNotSitting;
    }

    private static Optional<PositionTracker> getOwnerPosition(LivingEntity entity) {
        if (!(entity instanceof TameableDragonEntity)) {
            return Optional.empty();
        }
        TameableDragonEntity dragon = (TameableDragonEntity)entity;
        if (!dragon.isTame() || dragon.getOwner() == null) {
            return Optional.empty();
        }
        if (dragon.isOrderedToSit() || dragon.hasWanderTarget()) {
            return Optional.empty();
        }
        return Optional.of(new EntityTracker((Entity)dragon.getOwner(), true));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(TameableDragonEntity dragon) {
        if (BehaviorUtils.isBreeding((LivingEntity)dragon)) {
            return Optional.empty();
        }
        return dragon.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE);
    }

    private static Optional<PositionTracker> getWanderTarget(LivingEntity entity) {
        if (!(entity instanceof TameableDragonEntity)) {
            return Optional.empty();
        }
        TameableDragonEntity dragon = (TameableDragonEntity)entity;
        if (!dragon.hasWanderTarget() || dragon.getWanderTarget().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new BlockPosTracker(((GlobalPos)dragon.getWanderTarget().get()).pos()));
    }

    public static void selectMostAppropriateActivity(TameableDragonEntity dragon) {
        Brain<TameableDragonEntity> brain = dragon.getBrain();
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)ModActivityTypes.WANDER.get(), (Object)ModActivityTypes.SIT.get(), (Object)Activity.IDLE));
    }

    public static void wasHurtBy(TameableDragonEntity dragon, LivingEntity attacker) {
        Brain<TameableDragonEntity> brain = dragon.getBrain();
        brain.eraseMemory(MemoryModuleType.BREED_TARGET);
        DragonAI.maybeRetaliate(dragon, attacker);
    }

    public static void maybeRetaliate(TameableDragonEntity dragon, LivingEntity target) {
        boolean isTargetTooFarAway = BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget((LivingEntity)dragon, (LivingEntity)target, (double)4.0);
        boolean isTargetAttackable = Sensor.isEntityAttackable((LivingEntity)dragon, (LivingEntity)target);
        if (!isTargetTooFarAway && isTargetAttackable) {
            DragonAI.setAttackTarget(dragon, target);
        }
    }

    public static void setAttackTarget(TameableDragonEntity dragon, LivingEntity target) {
        Brain<TameableDragonEntity> brain = dragon.getBrain();
        brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        brain.eraseMemory(MemoryModuleType.BREED_TARGET);
        brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
        dragon.setTarget(target);
    }
}

