/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.registry;

import dmr.DragonMounts.types.breath.DragonBreathType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DragonBreathRegistry {
    private static final HashMap<String, DragonBreathType> BREATH_TYPES = new HashMap();

    public static void register(DragonBreathType breathType) {
        BREATH_TYPES.put(breathType.getId(), breathType);
    }

    public static void setBreathTypes(List<DragonBreathType> breathTypes) {
        BREATH_TYPES.clear();
        for (DragonBreathType breathType : breathTypes) {
            DragonBreathRegistry.register(breathType);
        }
    }

    public static DragonBreathType getBreathType(String name) {
        DragonBreathType val = BREATH_TYPES.getOrDefault(name, null);
        return val == null ? DragonBreathRegistry.getDefault() : val;
    }

    public static boolean hasBreathType(String name) {
        return BREATH_TYPES.containsKey(name);
    }

    public static List<DragonBreathType> getBreathTypes() {
        return new ArrayList<DragonBreathType>(BREATH_TYPES.values());
    }

    public static DragonBreathType getFirst() {
        return DragonBreathRegistry.getBreathTypes().stream().findFirst().orElse(new DragonBreathType());
    }

    public static DragonBreathType getDefault() {
        return DragonBreathRegistry.hasBreathType("fire") ? DragonBreathRegistry.getBreathType("fire") : DragonBreathRegistry.getFirst();
    }
}

