/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.config.ConfigProcessor;
import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.util.PlayerStateUtils;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ConfigSyncPacket
extends AbstractMessage<ConfigSyncPacket> {
    private static final StreamCodec<FriendlyByteBuf, ConfigSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, ConfigSyncPacket::getConfigData, (StreamCodec)ByteBufCodecs.BOOL, ConfigSyncPacket::isClientToServer, ConfigSyncPacket::new);
    private final CompoundTag configData;
    private final boolean clientToServer;

    ConfigSyncPacket() {
        this.configData = new CompoundTag();
        this.clientToServer = false;
    }

    public ConfigSyncPacket(CompoundTag configData, boolean clientToServer) {
        this.configData = configData;
        this.clientToServer = clientToServer;
    }

    public CompoundTag getConfigData() {
        return this.configData;
    }

    public boolean isClientToServer() {
        return this.clientToServer;
    }

    @Override
    protected String getTypeName() {
        return "config_sync";
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, ConfigSyncPacket> streamCodec() {
        return STREAM_CODEC;
    }

    public static ConfigSyncPacket createSyncPacket(boolean clientToServer) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, ConfigProcessor.ConfigField> entry : ConfigProcessor.getSyncedConfigs().entrySet()) {
            ConfigProcessor.ConfigField configField = entry.getValue();
            if ((!clientToServer || configField.isServerConfig()) && (clientToServer || !configField.isServerConfig()) || (!clientToServer || !configField.shouldSyncToServer()) && (clientToServer || !configField.shouldSyncToClient())) continue;
            String key = entry.getKey();
            try {
                Object value = configField.getValue();
                if (value instanceof Boolean) {
                    tag.putBoolean(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    tag.putInt(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Long) {
                    tag.putLong(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Double) {
                    tag.putDouble(key, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Float) {
                    tag.putFloat(key, ((Float)value).floatValue());
                    continue;
                }
                if (!(value instanceof String)) continue;
                tag.putString(key, (String)value);
            }
            catch (Exception e) {
                DMR.LOGGER.error("Failed to get config value for key: {}", (Object)key, (Object)e);
            }
        }
        return new ConfigSyncPacket(tag, clientToServer);
    }

    public static void syncServerToClient(Player player) {
        ConfigSyncPacket packet = ConfigSyncPacket.createSyncPacket(false);
        packet.sendToPlayer((ServerPlayer)player);
    }

    public static void syncClientToServer() {
        ConfigSyncPacket packet = ConfigSyncPacket.createSyncPacket(true);
        packet.sendToServer();
    }

    @Override
    public void handle(IPayloadContext context, Player player) {
        for (String key : this.configData.getAllKeys()) {
            ConfigProcessor.ConfigField configField = ConfigProcessor.getSyncedConfigs().get(key);
            if (configField == null) continue;
            boolean isClientSide = player.level().isClientSide;
            if (!(isClientSide && configField.isServerConfig() || !isClientSide && !configField.isServerConfig())) {
                DMR.LOGGER.debug("Skipping config value: {} on {}", (Object)key, (Object)(isClientSide ? "client" : "server"));
                continue;
            }
            DMR.LOGGER.debug("Applying config value: {} on {}", (Object)key, (Object)(isClientSide ? "client" : "server"));
            try {
                if (!isClientSide && this.clientToServer) {
                    DragonOwnerCapability handler = PlayerStateUtils.getHandler(player);
                    if (key.equals("camera_flight") && this.configData.contains(key, 1)) {
                        handler.cameraFlight = this.configData.getBoolean(key);
                        DMR.LOGGER.debug("Set player capability cameraFlight to {}", (Object)handler.cameraFlight);
                        continue;
                    }
                    if (key.equals("alternate_dismount") && this.configData.contains(key, 1)) {
                        handler.alternateDismount = this.configData.getBoolean(key);
                        DMR.LOGGER.debug("Set player capability alternateDismount to {}", (Object)handler.alternateDismount);
                        continue;
                    }
                    DMR.LOGGER.warn("Unknown client config key: {}", (Object)key);
                    continue;
                }
                if (this.configData.contains(key, 1)) {
                    configField.setValue(this.configData.getBoolean(key));
                    continue;
                }
                if (this.configData.contains(key, 3)) {
                    configField.setValue(this.configData.getInt(key));
                    continue;
                }
                if (this.configData.contains(key, 4)) {
                    configField.setValue(this.configData.getLong(key));
                    continue;
                }
                if (this.configData.contains(key, 6)) {
                    configField.setValue(this.configData.getDouble(key));
                    continue;
                }
                if (this.configData.contains(key, 5)) {
                    configField.setValue(Float.valueOf(this.configData.getFloat(key)));
                    continue;
                }
                if (!this.configData.contains(key, 8)) continue;
                configField.setValue(this.configData.getString(key));
            }
            catch (Exception e) {
                DMR.LOGGER.error("Failed to apply synced config value: {}", (Object)key, (Object)e);
            }
        }
    }
}

