/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.particle.particleoptions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dmr.DragonMounts.registry.ModParticles;
import dmr.DragonMounts.types.breath.DragonBreathType;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.joml.Vector3f;

public class DragonBreathParticleOptions
implements ParticleOptions {
    public static final Codec<List<Vector3f>> VECTOR3F_LIST_CODEC = ExtraCodecs.VECTOR3F.listOf();
    public static final MapCodec<DragonBreathParticleOptions> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)VECTOR3F_LIST_CODEC.fieldOf("gradientColors").forGetter(options -> options.gradientColors)).apply((Applicative)instance, DragonBreathParticleOptions::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DragonBreathParticleOptions> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, DragonBreathParticleOptions>(){

        public void encode(RegistryFriendlyByteBuf buffer, DragonBreathParticleOptions value) {
            buffer.writeVarInt(value.gradientColors.size());
            for (Vector3f color : value.gradientColors) {
                buffer.writeFloat(color.x());
                buffer.writeFloat(color.y());
                buffer.writeFloat(color.z());
            }
        }

        public DragonBreathParticleOptions decode(RegistryFriendlyByteBuf buffer) {
            int size = buffer.readVarInt();
            ArrayList<Vector3f> colors = new ArrayList<Vector3f>(size);
            for (int i = 0; i < size; ++i) {
                float r = buffer.readFloat();
                float g = buffer.readFloat();
                float b = buffer.readFloat();
                colors.add(new Vector3f(r, g, b));
            }
            return new DragonBreathParticleOptions(colors);
        }
    };
    private final List<Vector3f> gradientColors;

    public DragonBreathParticleOptions(DragonBreathType breathType) {
        this.gradientColors = breathType.getGradient().stream().map(c -> new Vector3f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f)).toList();
    }

    public DragonBreathParticleOptions(List<Vector3f> gradientColors) {
        if (gradientColors == null || gradientColors.isEmpty()) {
            throw new IllegalArgumentException("Gradient colors cannot be null or empty");
        }
        this.gradientColors = gradientColors;
    }

    public ParticleType<?> getType() {
        return ModParticles.DRAGON_BREATH_PARTICLE.get();
    }

    @Generated
    public List<Vector3f> getGradientColors() {
        return this.gradientColors;
    }
}

