/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.particle;

import dmr.DragonMounts.util.MiscUtils;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.ParticleRenderType;
import org.joml.Vector3f;

public class DragonBreathParticle
extends FlameParticle {
    private final List<Vector3f> gradientColors;

    public DragonBreathParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, List<Vector3f> gradientColors) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.gradientColors = gradientColors;
        Vector3f initialColor = gradientColors.getFirst();
        this.setColor(initialColor.x(), initialColor.y(), initialColor.z());
        this.scale(1.0f);
        this.lifetime = 20 + this.random.nextInt(12);
        this.alpha = 1.0f;
        this.hasPhysics = true;
    }

    public void tick() {
        super.tick();
        float lifetimeRatio = (float)this.age / (float)this.lifetime;
        float alphaLifetime = (float)this.age / ((float)this.lifetime * 2.0f);
        this.alpha = 1.0f * (1.0f - alphaLifetime);
        this.updateGradientColor(lifetimeRatio);
        this.scale(1.08f);
        this.yd += 0.004;
    }

    private void updateGradientColor(float progress) {
        if (this.gradientColors.size() == 1) {
            Vector3f color = this.gradientColors.getFirst();
            this.setColor(color.x(), color.y(), color.z());
            return;
        }
        progress = Math.max(0.0f, Math.min(1.0f, progress));
        float segmentCount = this.gradientColors.size() - 1;
        float segmentSize = 1.0f / segmentCount;
        int index = (int)(progress * segmentCount);
        index = Math.max(0, Math.min(index, this.gradientColors.size() - 2));
        float segmentProgress = (progress - (float)index * segmentSize) / segmentSize;
        segmentProgress = Math.max(0.0f, Math.min(1.0f, segmentProgress));
        Vector3f rgbA = this.gradientColors.get(index);
        Vector3f rgbB = this.gradientColors.get(index + 1);
        float[] hsvA = MiscUtils.rgbToHsv(rgbA.x(), rgbA.y(), rgbA.z());
        float[] hsvB = MiscUtils.rgbToHsv(rgbB.x(), rgbB.y(), rgbB.z());
        float[] hsvResult = new float[3];
        float hueDiff = hsvB[0] - hsvA[0];
        if (hueDiff > 0.5f) {
            hsvA[0] = hsvA[0] + 1.0f;
        }
        if (hueDiff < -0.5f) {
            hsvB[0] = hsvB[0] + 1.0f;
        }
        hsvResult[0] = hsvA[0] + segmentProgress * (hsvB[0] - hsvA[0]);
        hsvResult[1] = hsvA[1] + segmentProgress * (hsvB[1] - hsvA[1]);
        hsvResult[2] = hsvA[2] + segmentProgress * (hsvB[2] - hsvA[2]);
        hsvResult[0] = hsvResult[0] % 1.0f;
        float[] rgb = MiscUtils.hsvToRgb(hsvResult[0], hsvResult[1], hsvResult[2]);
        this.setColor(rgb[0], rgb[1], rgb[2]);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }
}

