/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dmr.DragonMounts.DMR;
import dmr.DragonMounts.types.abilities.types.Ability;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;

public class DragonAbilityButton
extends ExtendedButton {
    private static final ResourceLocation TITLE_BOX_SPRITE = ResourceLocation.withDefaultNamespace((String)"advancements/title_box");
    private static final ResourceLocation INVENTORY_LOCATION = DMR.id("textures/gui/dragon_inventory.png");
    private ResourceLocation ABILITY_ICON;
    private Minecraft minecraft;
    private FormattedCharSequence title;
    private int width;
    public List<FormattedCharSequence> description;

    public DragonAbilityButton(int xPos, int yPos, Ability ability) {
        super(xPos, yPos, 24, 24, (Component)Component.empty(), bt -> {});
        if (ability != null) {
            this.ABILITY_ICON = DMR.id("textures/gui/ability_icons/" + ability.type() + ".png");
            this.minecraft = Minecraft.getInstance();
            this.title = Language.getInstance().getVisualOrder(this.minecraft.font.substrByWidth((FormattedText)ability.getTranslatedName(), 160));
            this.description = ComponentRenderUtils.wrapComponents((FormattedText)ability.getTranslatedDescription().copy(), (int)120, (Font)this.minecraft.font);
            this.width = 29 + this.minecraft.font.width(this.title);
            for (FormattedCharSequence formattedcharsequence : this.description) {
                this.width = Math.max(this.width, this.minecraft.font.width(formattedcharsequence) + 15);
            }
        }
    }

    public void playDownSound(SoundManager pHandler) {
    }

    public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTick) {
        guiGraphics.blit(INVENTORY_LOCATION, this.getX(), this.getY(), 274.0f, 0.0f, 24, 24, 512, 512);
        if (this.ABILITY_ICON == null) {
            guiGraphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + 23, this.getY() + 23, FastColor.ARGB32.color((int)200, (int)0x5B5B5B));
            return;
        }
        guiGraphics.blit(this.ABILITY_ICON, this.getX() + 2, this.getY() + 2, 0.0f, 0.0f, 20, 20, 20, 20);
        if (this.isHovered()) {
            guiGraphics.pose().pushPose();
            RenderSystem.enableBlend();
            guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
            int l = this.getY() - 6;
            int i1 = this.getX();
            int j1 = 40 + this.description.size() * 9;
            if (!this.description.isEmpty()) {
                guiGraphics.blitSprite(TITLE_BOX_SPRITE, i1, l, this.width, j1);
            }
            guiGraphics.pose().pushPose();
            guiGraphics.blitSprite(ResourceLocation.withDefaultNamespace((String)"advancements/box_obtained"), 200, 26, 200, 0, (i1 += 2) + 2, l += 5, this.width - 10, 26);
            guiGraphics.blitSprite(ResourceLocation.withDefaultNamespace((String)"advancements/box_obtained"), 200, 26, 390, 0, i1 + (this.width - 15), l, 10, 26);
            guiGraphics.blitSprite(ResourceLocation.withDefaultNamespace((String)"advancements/task_frame_obtained"), i1, l, 26, 26);
            guiGraphics.pose().popPose();
            guiGraphics.pose().pushPose();
            guiGraphics.blit(this.ABILITY_ICON, i1 + 5, l + 5, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.pose().popPose();
            guiGraphics.drawCenteredString(this.minecraft.font, this.title, this.getX() + 28 + (this.width - 28 - 5) / 2, this.getY() + 8, -1);
            for (int k1 = 0; k1 < this.description.size(); ++k1) {
                guiGraphics.drawString(this.minecraft.font, this.description.get(k1), i1 + 5, l + 27 + k1 * 9, -5592406, false);
            }
            guiGraphics.pose().popPose();
        }
    }
}

