/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util.config;

import com.blackgear.platform.core.events.ServerLifecycleEvents;
import com.blackgear.platform.core.mixin.access.LevelResourceAccessor;
import com.blackgear.platform.core.networking.ConfigSyncPayload;
import com.blackgear.platform.core.networking.PayloadDistributor;
import com.blackgear.platform.core.networking.ServerListenerEvents;
import com.blackgear.platform.core.util.config.ConfigTracker;
import com.blackgear.platform.core.util.config.ModConfig;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigLoader {
    public static final Logger LOGGER = LogManager.getLogger();
    static final LevelResource SERVERCONFIG = LevelResourceAccessor.createLevelResource("serverconfig");

    private static Path getServerConfigPath(MinecraftServer server) {
        Path config = server.getWorldPath(SERVERCONFIG);
        ConfigLoader.getOrCreateDirectory(config, "serverconfig");
        return config;
    }

    public static void bootstrap() {
        ServerLifecycleEvents.STARTING.register(server -> ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ConfigLoader.getServerConfigPath(server)));
        ServerLifecycleEvents.STOPPING.register(server -> ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ConfigLoader.getServerConfigPath(server)));
        ServerListenerEvents.JOIN.register((handler, server) -> {
            ServerPlayer player = handler.player;
            if (server.isSingleplayerOwner(player.getGameProfile())) {
                return;
            }
            ConfigTracker.INSTANCE.configSets().get((Object)ModConfig.Type.SERVER).forEach(config -> {
                try {
                    String name = config.getFileName();
                    byte[] data = Files.readAllBytes(config.getFullPath());
                    PayloadDistributor.sendToPlayer(player, new ConfigSyncPayload(name, data));
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            });
        });
    }

    private static void getOrCreateDirectory(Path dirPath, String dirLabel) {
        if (!Files.isDirectory(dirPath.getParent(), new LinkOption[0])) {
            ConfigLoader.getOrCreateDirectory(dirPath.getParent(), "parent of " + dirLabel);
        }
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            LOGGER.debug("Making {} directory : {}", (Object)dirLabel, (Object)dirPath);
            try {
                Files.createDirectory(dirPath, new FileAttribute[0]);
            }
            catch (IOException exception) {
                if (exception instanceof FileAlreadyExistsException) {
                    LOGGER.fatal("Failed to create {} directory - there is a file in the way", (Object)dirLabel);
                } else {
                    LOGGER.fatal("Problem with creating {} directory (Permissions?)", (Object)dirLabel, (Object)exception);
                }
                throw new RuntimeException("Problem creating directory", exception);
            }
            LOGGER.debug("Created {} directory : {}", (Object)dirLabel, (Object)dirPath);
        } else {
            LOGGER.debug("Found existing {} directory : {}", (Object)dirLabel, (Object)dirPath);
        }
    }
}

