/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.core.data.recipes;

import com.soytutta.mynethersdelight.common.registry.MNDItems;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.Arrays;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MNDSmeltingRecipes {
    public static void register(RecipeOutput output) {
        MNDSmeltingRecipes.foodSmeltingRecipes("boiled_egg", Ingredient.of(MNDTags.BOILED_EGG_CANDIDATE), (ItemLike)MNDItems.BOILED_EGG.get(), 0.35f, output);
        MNDSmeltingRecipes.foodSmeltingRecipes("hoglin_loin", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_LOIN.get()}), (ItemLike)MNDItems.COOKED_LOIN.get(), 0.35f, output);
        MNDSmeltingRecipes.foodSmeltingRecipes("hoglin_sausage", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_SAUSAGE.get()}), (ItemLike)MNDItems.ROASTED_SAUSAGE.get(), 0.35f, output);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHAST_DOUGH.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD, (float)0.35f, (int)200).unlockedBy("has_dough", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHAST_DOUGH.get()})).save(output, String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"mynethersdelight", (String)"bread")) + "_from_smelting");
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHAST_DOUGH.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD, (float)0.35f, (int)100).unlockedBy("has_dough", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHAST_DOUGH.get()})).save(output, String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"mynethersdelight", (String)"bread")) + "_from_smoking");
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHAST_SOURDOUGH.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MNDItems.BREAD_LOAF_BLOCK.get()), (float)0.35f, (int)400).unlockedBy("has_dough", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHAST_SOURDOUGH.get()})).save(output, String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"mynethersdelight", (String)"bread_loaf")) + "_from_smelting");
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHAST_SOURDOUGH.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MNDItems.BREAD_LOAF_BLOCK.get()), (float)0.35f, (int)200).unlockedBy("has_dough", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHAST_SOURDOUGH.get()})).save(output, String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"mynethersdelight", (String)"bread_loaf")) + "_from_smoking");
        MNDSmeltingRecipes.foodSmeltingRecipes("toast", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.SLICES_OF_BREAD.get()}), (ItemLike)MNDItems.TOASTS.get(), 0.15f, output);
    }

    private static void foodSmeltingRecipes(String name, Ingredient ingredient, ItemLike result, float experience, RecipeOutput output) {
        String namePrefix = ResourceLocation.fromNamespaceAndPath((String)"mynethersdelight", (String)name).toString();
        ItemLike[] items = (ItemLike[])Arrays.stream(ingredient.getItems()).map(ItemStack::getItem).toArray(ItemLike[]::new);
        SimpleCookingRecipeBuilder smeltingRecipe = SimpleCookingRecipeBuilder.smelting((Ingredient)ingredient, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)200).unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
        smeltingRecipe.save(output, namePrefix + "_cooking");
        SimpleCookingRecipeBuilder campfireRecipe = SimpleCookingRecipeBuilder.campfireCooking((Ingredient)ingredient, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)600).unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
        campfireRecipe.save(output, namePrefix + "_from_campfire_cooking");
        SimpleCookingRecipeBuilder smokingRecipe = SimpleCookingRecipeBuilder.smoking((Ingredient)ingredient, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)100).unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
        smokingRecipe.save(output, namePrefix + "_from_smoking");
    }
}

