/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.core.data;

import com.soytutta.mynethersdelight.core.data.MNDBlockStates;
import com.soytutta.mynethersdelight.core.data.MNDBlockTags;
import com.soytutta.mynethersdelight.core.data.MNDDataMaps;
import com.soytutta.mynethersdelight.core.data.MNDItemTags;
import com.soytutta.mynethersdelight.core.data.MNDLang;
import com.soytutta.mynethersdelight.core.data.MNDRecipes;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="mynethersdelight", bus=EventBusSubscriber.Bus.MOD)
public class MNDDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        MNDBlockTags blockTags = new MNDBlockTags(output, lookupProvider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new MNDItemTags(output, lookupProvider, blockTags.contentsGetter(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new MNDRecipes(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new MNDDataMaps(output, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new MNDLang(output));
        MNDBlockStates blockStates = new MNDBlockStates(output, helper);
        generator.addProvider(event.includeClient(), (DataProvider)blockStates);
        generator.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, new RegistrySetBuilder(), Set.of("mynethersdelight")));
    }
}

