/*
 * Decompiled with CFR 0.152.
 */
package toni.foolproof.mixins;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import toni.foolproof.Foolproof;

@Mixin(value={DisconnectedScreen.class})
public class DisconnectedScreenMixin {
    @Shadow
    @Final
    @Mutable
    private DisconnectionDetails details;

    @Redirect(method={"init()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/layouts/LinearLayout;addChild(Lnet/minecraft/client/gui/layouts/LayoutElement;)Lnet/minecraft/client/gui/layouts/LayoutElement;"))
    private <T extends LayoutElement> T onInit(LinearLayout instance, T child) {
        try {
            Object[] messages = ((TranslatableContents)this.details.reason().getContents()).getArgs();
            Component reasonObj = this.details.reason();
            if (messages.length == 0) {
                return null;
            }
            String message = messages[0].toString();
            if (message.equals("Connection refused: getsockopt")) {
                DisconnectedScreen screen = (DisconnectedScreen)this;
                MutableComponent title = Component.literal((String)"This usually means the server is down, or the network is blocking it!");
                instance.addChild((LayoutElement)new MultiLineTextWidget((Component)title, Minecraft.getInstance().font).setMaxWidth(screen.width - 50).setCentered(true));
                MutableComponent newReason = Component.literal((String)"\u25aa Check if your server is visible to others with ").append((Component)Component.literal((String)"https://mcsrvstat.us/").withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://mcsrvstat.us/")))).append("\n\u25aa If it's not reachable, make sure the port is open!").append("\n\u25aa If it is up, check your internet connection and firewall settings!");
                MultiLineTextWidget widget = new MultiLineTextWidget(reasonObj, Minecraft.getInstance().font).setMaxWidth(screen.width - 50);
                this.details = new DisconnectionDetails((Component)newReason, this.details.report(), this.details.bugReportLink());
                return (T)instance.addChild((LayoutElement)widget);
            }
        }
        catch (Exception e) {
            Foolproof.LOGGER.error((Object)e);
        }
        return (T)instance.addChild(child);
    }
}

