/*
 * Decompiled with CFR 0.152.
 */
package toni.foolproof.features;

import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageTypes;
import toni.lib.utils.PlatformUtils;

public class VoidGraveReminder {
    private static final Set<String> GRAVE_MODS = Set.of("yigd", "corpse");

    public static void init() {
        ServerPlayerEvents.ALLOW_DEATH.register((player, damageSource, damageAmount) -> {
            if (!damageSource.is(DamageTypes.FELL_OUT_OF_WORLD)) {
                return true;
            }
            if (!GRAVE_MODS.stream().anyMatch(PlatformUtils::isModLoaded)) {
                return true;
            }
            PlayerChatMessage chatMessage = PlayerChatMessage.unsigned((UUID)player.getUUID(), (String)"Your grave is still accessible at Y=0!");
            CommandSourceStack cmd = player.createCommandSourceStack();
            cmd.sendChatMessage((OutgoingChatMessage)new OutgoingChatMessage.Player(chatMessage), false, ChatType.bind((ResourceKey)ChatType.MSG_COMMAND_INCOMING, (RegistryAccess)cmd.registryAccess(), (Component)Component.literal((String)"The Void")));
            return true;
        });
    }
}

