/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.mixins;

import com.mojang.blaze3d.audio.Channel;
import java.util.Map;
import namelessju.audioimprovements.common.AudioImprovements;
import namelessju.audioimprovements.common.data.SoundChannelType;
import namelessju.audioimprovements.common.mixinaccessors.SoundChannelMixinAccessor;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SoundEngine.class})
public abstract class SoundEngineMixin {
    @Redirect(method={"play"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", ordinal=1))
    private Object audioImprovements$onSourcesPut(Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel, Object soundObj, Object channelHandleObj) {
        SoundInstance soundInstance = (SoundInstance)soundObj;
        ChannelAccess.ChannelHandle channelHandle = (ChannelAccess.ChannelHandle)channelHandleObj;
        channelHandle.execute(source -> {
            SoundChannelMixinAccessor mixinAccessor = (SoundChannelMixinAccessor)source;
            String soundPath = soundInstance.getLocation().getPath();
            if (soundPath.startsWith("music_disc")) {
                mixinAccessor.audioImprovements$setSoundType(SoundChannelType.MUSIC_DISC);
                AudioImprovements.getInstance().musicBlockChannels.add((Channel)source);
                AudioImprovements.LOGGER.debug("Music disc played");
            } else if (soundPath.startsWith("block.note_block")) {
                mixinAccessor.audioImprovements$setSoundType(SoundChannelType.NOTE_BLOCK);
                AudioImprovements.getInstance().musicBlockChannels.add((Channel)source);
                AudioImprovements.LOGGER.debug("Note block played");
            } else {
                switch (soundInstance.getSource()) {
                    case WEATHER: {
                        mixinAccessor.audioImprovements$setSoundType(SoundChannelType.WEATHER);
                        break;
                    }
                    case BLOCKS: {
                        mixinAccessor.audioImprovements$setSoundType(SoundChannelType.BLOCKS);
                        break;
                    }
                    case HOSTILE: {
                        mixinAccessor.audioImprovements$setSoundType(SoundChannelType.HOSTILE);
                        break;
                    }
                    case NEUTRAL: {
                        mixinAccessor.audioImprovements$setSoundType(SoundChannelType.NEUTRAL);
                        break;
                    }
                    case PLAYERS: {
                        mixinAccessor.audioImprovements$setSoundType(SoundChannelType.PLAYERS);
                        break;
                    }
                    case AMBIENT: {
                        mixinAccessor.audioImprovements$setSoundType(SoundChannelType.AMBIENT);
                        break;
                    }
                    case MUSIC: {
                        Sound sound = soundInstance.getSound();
                        if (sound == null) break;
                        AudioImprovements.getInstance().lastPlayedMusic = sound.getLocation();
                        AudioImprovements.LOGGER.debug("Played music \"{}\"", (Object)AudioImprovements.getInstance().lastPlayedMusic);
                    }
                }
            }
        });
        return instanceToChannel.put(soundInstance, channelHandle);
    }

    @Inject(method={"calculateVolume(FLnet/minecraft/sounds/SoundSource;)F"}, at={@At(value="HEAD")}, cancellable=true)
    private void audioImprovements$calculateVolume(float baseVolume, SoundSource soundSource, CallbackInfoReturnable<Float> cir) {
        float volumeMultiplier;
        if (soundSource == SoundSource.MUSIC && (volumeMultiplier = AudioImprovements.getInstance().musicVolumeMultiplier) != 1.0f) {
            float sourceVolume = this.getVolume(soundSource);
            cir.setReturnValue((Object)Float.valueOf(Mth.clamp((float)(baseVolume * sourceVolume * volumeMultiplier), (float)1.0E-5f, (float)1.0f)));
            if (AudioImprovements.LOGGER.isDebugEnabled()) {
                AudioImprovements.LOGGER.debug("Calculated faded music volume as {} (base: {}, source: {}, multiplier: {})", new Object[]{Float.valueOf(cir.getReturnValueF()), Float.valueOf(baseVolume), Float.valueOf(sourceVolume), Float.valueOf(volumeMultiplier)});
            }
            cir.cancel();
        }
    }

    @Shadow
    protected abstract float getVolume(@Nullable SoundSource var1);
}

