/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.mixins;

import com.mojang.blaze3d.audio.Channel;
import namelessju.audioimprovements.common.AudioImprovements;
import namelessju.audioimprovements.common.data.SoundChannelType;
import namelessju.audioimprovements.common.mixinaccessors.SoundChannelMixinAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL10;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Channel.class})
public abstract class SoundChannelMixin
implements SoundChannelMixinAccessor {
    @Shadow
    @Final
    private int source;
    @Unique
    @Nullable
    private SoundChannelType audioImprovements$type = null;
    @Unique
    @Nullable
    private Vec3 audioImprovements$posOriginal = null;
    @Unique
    @Nullable
    private Boolean audioImprovements$isRelativeOriginal = null;
    @Unique
    private float audioImprovements$attenuationOriginal = 1.0f;
    @Unique
    private float audioImprovements$attenuationMultiplier = 1.0f;
    @Unique
    private boolean audioImprovements$monoBefore = false;

    @Inject(method={"play"}, at={@At(value="HEAD")})
    private void audioImprovements$play(CallbackInfo ci) {
        this.audioImprovements$updatePosition();
    }

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    private void audioImprovements$stop(CallbackInfo ci) {
        this.audioImprovements$removeMusicBlockSource();
    }

    @Inject(method={"destroy"}, at={@At(value="HEAD")})
    private void audioImprovements$destroy(CallbackInfo ci) {
        this.audioImprovements$removeMusicBlockSource();
    }

    @Inject(method={"setSelfPosition"}, at={@At(value="HEAD")}, cancellable=true)
    private void audioImprovements$setSelfPosition(Vec3 pos, CallbackInfo ci) {
        this.audioImprovements$posOriginal = pos;
        if (this.audioImprovements$isMono()) {
            ci.cancel();
        }
    }

    @Inject(method={"setRelative"}, at={@At(value="HEAD")}, cancellable=true)
    private void audioImprovements$setRelative(boolean relative, CallbackInfo ci) {
        this.audioImprovements$isRelativeOriginal = relative;
        if (this.audioImprovements$isMono()) {
            ci.cancel();
        }
    }

    @Inject(method={"updateStream"}, at={@At(value="HEAD")})
    private void audioImprovements$updateStream(CallbackInfo ci) {
        this.audioImprovements$updatePosition();
        float attenuationMultiplier = AudioImprovements.getInstance().getAttenuationMultiplier(this.audioImprovements$type);
        if (this.audioImprovements$attenuationMultiplier != attenuationMultiplier) {
            this.audioImprovements$attenuationMultiplier = attenuationMultiplier;
            this.audioImprovements$applyAttenuation();
        }
    }

    @Inject(method={"linearAttenuation"}, at={@At(value="HEAD")}, cancellable=true)
    private void audioImprovements$linearAttenuation(float attenuation, CallbackInfo ci) {
        this.audioImprovements$attenuationOriginal = attenuation;
        AL10.alSourcei((int)this.source, (int)53248, (int)53251);
        AL10.alSourcef((int)this.source, (int)4129, (float)1.0f);
        AL10.alSourcef((int)this.source, (int)4128, (float)0.0f);
        this.audioImprovements$applyAttenuation();
        ci.cancel();
    }

    @Override
    public void audioImprovements$setSoundType(SoundChannelType type) {
        this.audioImprovements$type = type;
    }

    @Override
    public SoundChannelType audioImprovements$getSoundType() {
        return this.audioImprovements$type;
    }

    @Override
    public Vec3 audioImprovements$getPos() {
        return this.audioImprovements$posOriginal;
    }

    @Override
    public float audioImprovements$getMaxDistance() {
        if (this.audioImprovements$attenuationMultiplier < 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        return this.audioImprovements$attenuationOriginal * this.audioImprovements$attenuationMultiplier;
    }

    @Unique
    private boolean audioImprovements$isMono() {
        return AudioImprovements.getInstance().isSoundTypeMono(this.audioImprovements$type);
    }

    @Unique
    private void audioImprovements$updatePosition() {
        if (this.audioImprovements$posOriginal == null) {
            return;
        }
        if (this.audioImprovements$isMono()) {
            AL10.alSourcei((int)this.source, (int)514, (int)1);
            if (!Boolean.TRUE.equals(this.audioImprovements$isRelativeOriginal)) {
                Vec3 listenerPos = Minecraft.getInstance().getSoundManager().getListenerTransform().position();
                float distanceToListener = (float)listenerPos.distanceTo(this.audioImprovements$posOriginal);
                AL10.alSourcefv((int)this.source, (int)4100, (float[])new float[]{0.0f, 0.0f, distanceToListener});
            } else {
                AL10.alSourcefv((int)this.source, (int)4100, (float[])new float[]{(float)this.audioImprovements$posOriginal.x, (float)this.audioImprovements$posOriginal.y, (float)this.audioImprovements$posOriginal.z});
            }
            this.audioImprovements$monoBefore = true;
        } else if (this.audioImprovements$monoBefore) {
            AL10.alSourcei((int)this.source, (int)514, (int)(Boolean.TRUE.equals(this.audioImprovements$isRelativeOriginal) ? 1 : 0));
            AL10.alSourcefv((int)this.source, (int)4100, (float[])new float[]{(float)this.audioImprovements$posOriginal.x, (float)this.audioImprovements$posOriginal.y, (float)this.audioImprovements$posOriginal.z});
            this.audioImprovements$monoBefore = false;
            AudioImprovements.LOGGER.debug("Reset sound {} position from mono to true 3D", (Object)this.source);
        }
    }

    @Unique
    private void audioImprovements$applyAttenuation() {
        if (AL10.alGetSourcei((int)this.source, (int)53248) != 53251) {
            return;
        }
        AL10.alSourcef((int)this.source, (int)4131, (float)this.audioImprovements$getMaxDistance());
    }

    @Unique
    private void audioImprovements$removeMusicBlockSource() {
        boolean wasRemoved;
        if ((this.audioImprovements$type == SoundChannelType.MUSIC_DISC || this.audioImprovements$type == SoundChannelType.NOTE_BLOCK) && (wasRemoved = AudioImprovements.getInstance().musicBlockChannels.remove((Channel)this)) && AudioImprovements.LOGGER.isDebugEnabled()) {
            AudioImprovements.LOGGER.debug("Removed reference to music block sound channel ({} references left)", (Object)AudioImprovements.getInstance().musicBlockChannels.size());
        }
    }
}

