/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.mixins;

import com.llamalad7.mixinextras.sugar.Local;
import namelessju.audioimprovements.common.AudioImprovements;
import namelessju.audioimprovements.common.ConfigImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicManager.class})
public abstract class MusicManagerMixin {
    @Shadow
    @Final
    private RandomSource random;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Nullable
    private SoundInstance currentMusic;
    @Unique
    private Music audioImprovements$music = null;

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void audioImprovements$tick(CallbackInfo ci) {
        if (this.currentMusic == null) {
            return;
        }
        AudioImprovements mod = AudioImprovements.getInstance();
        float newVolumeMultiplier = 1.0f;
        if (this.minecraft.player != null) {
            float targetMultiplier;
            float f = targetMultiplier = mod.shouldFadeMusic() ? 0.0f : 1.0f;
            if (targetMultiplier != mod.musicVolumeMultiplier) {
                ConfigImpl config = AudioImprovements.getInstance().config;
                float volumeChange = targetMultiplier - mod.musicVolumeMultiplier;
                volumeChange = volumeChange > 0.0f ? Math.min(volumeChange, 1.0f / (float)Math.max(config.musicFadeInSeconds.getValue() * 20, 1)) : Math.max(volumeChange, -1.0f / (float)Math.max(config.musicFadeOutSeconds.getValue() * 20, 1));
                newVolumeMultiplier = mod.musicVolumeMultiplier + volumeChange;
            } else {
                newVolumeMultiplier = targetMultiplier;
            }
        }
        if (newVolumeMultiplier != mod.musicVolumeMultiplier) {
            mod.musicVolumeMultiplier = newVolumeMultiplier;
            this.audioImprovements$updateSoundVolume();
        }
        this.audioImprovements$music = null;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/neoforged/neoforge/client/ClientHooks;selectMusic(Lnet/minecraft/sounds/Music;Lnet/minecraft/client/resources/sounds/SoundInstance;)Lnet/minecraft/sounds/Music;", ordinal=0)})
    private void audioImprovements$captureMusic(CallbackInfo ci, @Local Music music) {
        this.audioImprovements$music = music;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;nextInt(Lnet/minecraft/util/RandomSource;II)I", ordinal=1))
    private int audioImprovements$redirectMusicDelay1(RandomSource randomSource, int min, int max) {
        int customDelay = this.audioImprovements$getNextSongDelay(randomSource);
        return customDelay >= 0 ? customDelay : Mth.nextInt((RandomSource)randomSource, (int)min, (int)max);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/sounds/Music;getMaxDelay()I", ordinal=1))
    private int audioImprovements$redirectMusicDelay2(Music music) {
        int customDelay = this.audioImprovements$getNextSongDelay(this.random);
        return customDelay >= 0 ? customDelay : music.getMaxDelay();
    }

    @Unique
    private void audioImprovements$updateSoundVolume() {
        this.minecraft.getSoundManager().updateSourceVolume(SoundSource.MUSIC, 1.0f);
    }

    @Unique
    private int audioImprovements$getNextSongDelay(RandomSource randomSource) {
        ConfigImpl config = AudioImprovements.getInstance().config;
        if (config.customMusicFrequency.isEnabled) {
            if (this.audioImprovements$music != null && this.audioImprovements$music.getEvent().value() == SoundEvents.MUSIC_MENU.value() && !config.musicFrequencyAffectMenu.isEnabled) {
                return -1;
            }
            return Mth.nextInt((RandomSource)randomSource, (int)config.musicFrequencyMinTicks.getValue(), (int)config.musicFrequencyMaxTicks.getValue());
        }
        return -1;
    }
}

