/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.mixins;

import java.util.Objects;
import namelessju.audioimprovements.common.AudioImprovements;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={AbstractSoundInstance.class})
public abstract class AbstractSoundInstanceMixin {
    @Unique
    private static final int audioImprovements$MAX_REPEAT_PREVENTION_TRIES = 100;
    @Shadow
    @Final
    protected SoundSource source;

    @Redirect(method={"resolve"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/sounds/WeighedSoundEvents;getSound(Lnet/minecraft/util/RandomSource;)Lnet/minecraft/client/resources/sounds/Sound;", ordinal=0))
    private Sound audioImprovements$getSound(WeighedSoundEvents weighedSoundEvents, RandomSource randomSource) {
        if (this.source == SoundSource.MUSIC) {
            AudioImprovements mod = AudioImprovements.getInstance();
            if (mod.config.preventMusicRepeat.isEnabled && mod.lastPlayedMusic != null) {
                Sound sound;
                int tries = 0;
                while ((sound = weighedSoundEvents.getSound(randomSource)) != SoundManager.EMPTY_SOUND && ++tries <= 100 && Objects.equals(sound.getLocation(), mod.lastPlayedMusic)) {
                }
                if (tries > 1) {
                    if (tries <= 100) {
                        AudioImprovements.LOGGER.debug("Prevented playing repeat music \"{}\" x{}", (Object)mod.lastPlayedMusic, (Object)(tries - 1));
                    } else {
                        AudioImprovements.LOGGER.warn("Ran out of tries while trying to prevent repeat music \"{}\" (exceeded {} tries)", (Object)mod.lastPlayedMusic, (Object)100);
                    }
                }
                return sound;
            }
        }
        return weighedSoundEvents.getSound(randomSource);
    }
}

