/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.gui;

import java.util.function.BiConsumer;
import namelessju.audioimprovements.common.gui.Slider;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ValueListSlider<T>
extends Slider<T> {
    private final T[] values;
    @NotNull
    private final BiConsumer<Integer, T> onValueChanged;

    public ValueListSlider(int x, int y, int width, int height, @NotNull Component name, @NotNull Slider.ValueComponentProvider<T> valueComponentProvider, @NotNull T[] values, @NotNull T initialValue, @NotNull BiConsumer<Integer, T> onValueChanged) {
        super(x, y, width, height, name, valueComponentProvider);
        this.values = values;
        this.onValueChanged = onValueChanged;
        this.setValue(initialValue);
        this.updateMessage();
    }

    private void updateValue(int index) {
        this.value = Mth.clamp((double)this.indexToSliderValue(index), (double)0.0, (double)1.0);
        this.onValueChanged.accept(index, (Integer)this.getValue());
    }

    protected void applyValue() {
        this.updateValue(this.sliderValueToIndex());
    }

    @Override
    public T getValue() {
        return this.values[Mth.clamp((int)this.sliderValueToIndex(), (int)0, (int)(this.values.length - 1))];
    }

    public boolean keyPressed(int i, int j, int k) {
        double valueBefore = this.value;
        if (super.keyPressed(i, j, k)) {
            boolean keyLeftPressed;
            this.value = valueBefore;
            boolean bl = keyLeftPressed = i == 263;
            if (keyLeftPressed || i == 262) {
                this.setIndex(this.sliderValueToIndex() + (keyLeftPressed ? -1 : 1));
            }
            return true;
        }
        return false;
    }

    public void setIndex(int index) {
        this.updateValue(index);
        this.updateMessage();
    }

    public void setValue(T value) {
        int index = -1;
        for (int i = 0; i < this.values.length; ++i) {
            if (!value.equals(this.values[i])) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        this.setIndex(index);
    }

    private int sliderValueToIndex() {
        return (int)Math.round((double)(this.values.length - 1) * this.value);
    }

    private double indexToSliderValue(int integer) {
        return (double)integer / (double)(this.values.length - 1);
    }
}

