/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.gui;

import java.util.function.Consumer;
import namelessju.audioimprovements.common.gui.Slider;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class IntegerSlider
extends Slider<Integer> {
    public static final Slider.ValueComponentProvider<Integer> DEFAULT_COMPONENT_SUPPLIER = value -> Component.literal((String)Integer.toString(value));
    private final int min;
    private final int max;
    public int stepSize = -1;
    @NotNull
    private final Consumer<Integer> onValueChanged;

    public IntegerSlider(int x, int y, int width, int height, @NotNull Component name, int min, int max, int initialValue, @NotNull Consumer<Integer> onValueChanged) {
        super(x, y, width, height, name, DEFAULT_COMPONENT_SUPPLIER);
        this.min = min;
        this.max = max;
        this.onValueChanged = onValueChanged;
        this.updateValue(initialValue);
        this.updateMessage();
    }

    @Override
    public Integer getValue() {
        return this.sliderValueToInt();
    }

    protected void applyValue() {
        this.updateValue(this.sliderValueToInt());
        this.onValueChanged.accept(this.sliderValueToInt());
    }

    public boolean keyPressed(int i, int j, int k) {
        double valueBefore = this.value;
        if (super.keyPressed(i, j, k)) {
            boolean keyLeftPressed;
            this.value = valueBefore;
            boolean bl = keyLeftPressed = i == 263;
            if (keyLeftPressed || i == 262) {
                this.setValue(this.sliderValueToInt() + (keyLeftPressed ? -this.stepSize : this.stepSize));
            }
            return true;
        }
        return false;
    }

    private void updateValue(int value) {
        this.value = Mth.clamp((double)this.intToSliderValue(value), (double)0.0, (double)1.0);
    }

    public void setValue(int value) {
        this.updateValue(value);
        this.onValueChanged.accept(this.sliderValueToInt());
        this.updateMessage();
    }

    private int sliderValueToInt() {
        int stepSize = this.stepSize > 0 ? this.stepSize : 1;
        float relativeValue = (float)((double)(this.max - this.min) * this.value);
        return this.min + Math.round(relativeValue / (float)stepSize) * stepSize;
    }

    private double intToSliderValue(int integer) {
        return (double)(integer - this.min) / (double)(this.max - this.min);
    }
}

