/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.gui;

import namelessju.audioimprovements.common.ConfigImpl;
import namelessju.audioimprovements.common.data.MusicFrequencyValue;
import namelessju.audioimprovements.common.gui.ConfigList;
import namelessju.audioimprovements.common.gui.IntegerSlider;
import namelessju.audioimprovements.common.gui.Slider;
import namelessju.audioimprovements.common.gui.ValueListSlider;
import namelessju.audioimprovements.common.gui.WidgetFactory;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigScreen
extends Screen {
    private final Screen parent;
    private final ConfigImpl config;
    public final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private ConfigList list;
    private ValueListSlider<MusicFrequencyValue> musicFrequencyMinSlider;
    private ValueListSlider<MusicFrequencyValue> musicFrequencyMaxSlider;
    private CycleButton<Boolean> musicFrequencyAffectMenuButton;

    public ConfigScreen(Screen parent, ConfigImpl config) {
        super((Component)Component.translatable((String)"audioimprovements.config.title"));
        this.parent = parent;
        this.config = config;
    }

    protected void init() {
        this.layout.addTitleHeader(this.title, this.font);
        this.list = (ConfigList)this.layout.addToContents((LayoutElement)new ConfigList(this.minecraft, this));
        this.list.addSection((Component)Component.translatable((String)"audioimprovements.config.section.mono"));
        this.list.addTwoColumns((AbstractWidget)this.config.monoMusicDiscs.createButton(0, 0, 0, null), (AbstractWidget)this.config.monoNoteBlocks.createButton(0, 0, 0, null));
        this.list.addTwoColumns((AbstractWidget)this.config.monoWeather.createButton(0, 0, 0, null), (AbstractWidget)this.config.monoBlocks.createButton(0, 0, 0, null));
        this.list.addTwoColumns((AbstractWidget)this.config.monoHostile.createButton(0, 0, 0, null), (AbstractWidget)this.config.monoNeutral.createButton(0, 0, 0, null));
        this.list.addTwoColumns((AbstractWidget)this.config.monoPlayers.createButton(0, 0, 0, null), (AbstractWidget)this.config.monoAmbient.createButton(0, 0, 0, null));
        this.list.addSection((Component)Component.translatable((String)"audioimprovements.config.section.musicDiscs"));
        IntegerSlider musicDiscDistanceSlider = this.config.maxDistancePercentMusicDiscs.createSlider(0, 0, 0, null);
        this.list.addFullWidth((AbstractWidget)musicDiscDistanceSlider);
        musicDiscDistanceSlider.setTooltip(Tooltip.create((Component)this.config.maxDistancePercentMusicDiscs.getTooltipComponent()));
        musicDiscDistanceSlider.stepSize = 10;
        musicDiscDistanceSlider.setValueComponentSupplier(value -> {
            if (value > 300) {
                return this.config.maxDistancePercentMusicDiscs.getTranslatableComponent("global");
            }
            return Component.literal((String)Integer.toString(value)).append("%");
        });
        this.list.addSection((Component)Component.translatable((String)"audioimprovements.config.section.musicClashPrevention"));
        this.list.addFullWidth((AbstractWidget)this.config.fadeMusicWhenMusicDiscPlaying.createButton(0, 0, 0, null));
        this.list.addFullWidth((AbstractWidget)this.config.fadeMusicWhenNoteBlockPlaying.createButton(0, 0, 0, null));
        IntegerSlider musicFadeOutSlider = this.config.musicFadeOutSeconds.createSlider(0, 0, 0, null);
        IntegerSlider musicFadeInSlider = this.config.musicFadeInSeconds.createSlider(0, 0, 0, null);
        this.list.addTwoColumns((AbstractWidget)musicFadeOutSlider, (AbstractWidget)musicFadeInSlider);
        Slider.ValueComponentProvider<Integer> musicFadeComponentSupplier = value -> Component.empty().append(Integer.toString(value)).append(" ").append((Component)Component.translatable((String)"audioimprovements.time.seconds"));
        musicFadeOutSlider.setValueComponentSupplier(musicFadeComponentSupplier);
        musicFadeInSlider.setValueComponentSupplier(musicFadeComponentSupplier);
        this.list.addSection((Component)Component.translatable((String)"audioimprovements.config.section.music"));
        this.list.addFullWidth((AbstractWidget)this.config.preventMusicRepeat.createButton(0, 0, 0, null));
        this.list.addSection((Component)Component.translatable((String)"audioimprovements.config.section.musicFrequency"));
        this.list.addFullWidth((AbstractWidget)this.config.customMusicFrequency.createButton(0, 0, 0, enabled -> this.updateMusicFrequencyWidgets()));
        this.musicFrequencyMinSlider = MusicFrequencyValue.createConfigSlider(this.config.musicFrequencyMinTicks, (index, value) -> {
            if (value.ticks > this.config.musicFrequencyMaxTicks.getValue()) {
                this.config.musicFrequencyMaxTicks.setValue(value.ticks);
                this.musicFrequencyMaxSlider.setIndex((int)index);
            }
        });
        this.musicFrequencyMaxSlider = MusicFrequencyValue.createConfigSlider(this.config.musicFrequencyMaxTicks, (index, value) -> {
            if (value.ticks < this.config.musicFrequencyMinTicks.getValue()) {
                this.config.musicFrequencyMinTicks.setValue(value.ticks);
                this.musicFrequencyMinSlider.setIndex((int)index);
            }
        });
        this.list.addFullWidth((AbstractWidget)this.musicFrequencyMinSlider);
        this.list.addFullWidth((AbstractWidget)this.musicFrequencyMaxSlider);
        this.musicFrequencyAffectMenuButton = this.config.musicFrequencyAffectMenu.createButton(0, 0, 0, null);
        this.list.addFullWidth((AbstractWidget)this.musicFrequencyAffectMenuButton);
        this.updateMusicFrequencyWidgets();
        this.layout.addToFooter((LayoutElement)WidgetFactory.buildDoneButton(this));
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private void updateMusicFrequencyWidgets() {
        boolean enabled;
        this.musicFrequencyMinSlider.active = enabled = this.config.customMusicFrequency.isEnabled;
        this.musicFrequencyMaxSlider.active = enabled;
        this.musicFrequencyAffectMenuButton.active = enabled;
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.list != null) {
            this.list.updateSize(this.width, this.layout);
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public void removed() {
        this.config.save();
    }
}

