/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import namelessju.audioimprovements.common.gui.ConfigScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigList
extends ContainerObjectSelectionList<Entry> {
    private final ConfigScreen screen;

    public ConfigList(Minecraft minecraft, ConfigScreen screen) {
        super(minecraft, screen.width, screen.layout.getContentHeight(), screen.layout.getHeaderHeight(), 25);
        this.screen = screen;
        this.centerListVertically = false;
    }

    public void addFullWidth(@NotNull AbstractWidget widget) {
        widget.setWidth(this.getRowWidth());
        Entry entry = new Entry(List.of(widget), this.screen);
        entry.yOffset = widget.getY();
        this.addEntry((AbstractSelectionList.Entry)entry);
    }

    public void addTwoColumns(@NotNull AbstractWidget widgetLeft, @Nullable AbstractWidget widgetRight) {
        List<AbstractWidget> widgetList;
        widgetLeft.setWidth(150);
        if (widgetRight != null) {
            widgetRight.setWidth(150);
            widgetList = List.of(widgetLeft, widgetRight);
        } else {
            widgetList = List.of(widgetLeft);
        }
        this.addEntry((AbstractSelectionList.Entry)new Entry(widgetList, this.screen));
    }

    public void addSection(Component component) {
        this.addFullWidth((AbstractWidget)new StringWidget(0, 7, 0, 9, component, this.minecraft.font).alignCenter());
    }

    public int getRowWidth() {
        return 310;
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected final List<AbstractWidget> children;
        private final Screen screen;
        public int yOffset = 0;

        public Entry(List<AbstractWidget> children, Screen screen) {
            this.children = ImmutableList.copyOf(children);
            this.screen = screen;
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        public void render(GuiGraphics guiGraphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
            int x = this.screen.width / 2 - 155;
            for (AbstractWidget abstractWidget : this.children) {
                abstractWidget.setPosition(x, j + this.yOffset);
                abstractWidget.render(guiGraphics, n, o, f);
                x += abstractWidget.getWidth() + 10;
            }
        }
    }
}

