/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.data;

import java.util.function.BiConsumer;
import namelessju.audioimprovements.common.config.IntegerEntry;
import namelessju.audioimprovements.common.gui.Slider;
import namelessju.audioimprovements.common.gui.ValueListSlider;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class MusicFrequencyValue {
    private static final Component SUFFIX_SECONDS = Component.translatable((String)"audioimprovements.time.seconds");
    private static final Component SUFFIX_MINUTES = Component.translatable((String)"audioimprovements.time.minutes");
    public static final MusicFrequencyValue[] VALUES = new MusicFrequencyValue[]{new MusicFrequencyValue(0, false), new MusicFrequencyValue(1, false), new MusicFrequencyValue(2, false), new MusicFrequencyValue(3, false), new MusicFrequencyValue(4, false), new MusicFrequencyValue(5, false), new MusicFrequencyValue(6, false), new MusicFrequencyValue(7, false), new MusicFrequencyValue(8, false), new MusicFrequencyValue(9, false), new MusicFrequencyValue(10, false), new MusicFrequencyValue(15, false), new MusicFrequencyValue(20, false), new MusicFrequencyValue(25, false), new MusicFrequencyValue(30, false), new MusicFrequencyValue(35, false), new MusicFrequencyValue(40, false), new MusicFrequencyValue(45, false), new MusicFrequencyValue(50, false), new MusicFrequencyValue(55, false), new MusicFrequencyValue(1, true), new MusicFrequencyValue(2, true), new MusicFrequencyValue(3, true), new MusicFrequencyValue(4, true), new MusicFrequencyValue(5, true), new MusicFrequencyValue(6, true), new MusicFrequencyValue(7, true), new MusicFrequencyValue(8, true), new MusicFrequencyValue(9, true), new MusicFrequencyValue(10, true), new MusicFrequencyValue(15, true), new MusicFrequencyValue(20, true), new MusicFrequencyValue(25, true), new MusicFrequencyValue(30, true), new MusicFrequencyValue(35, true), new MusicFrequencyValue(40, true), new MusicFrequencyValue(45, true), new MusicFrequencyValue(50, true), new MusicFrequencyValue(55, true), new MusicFrequencyValue(60, true)};
    public static final Slider.ValueComponentProvider<MusicFrequencyValue> VALUE_COMPONENT_PROVIDER = value -> value.valueComponent;
    public final int ticks;
    private final Component valueComponent;

    public static ValueListSlider<MusicFrequencyValue> createConfigSlider(IntegerEntry configEntry, @Nullable BiConsumer<Integer, MusicFrequencyValue> onValueChanged) {
        return new ValueListSlider<MusicFrequencyValue>(0, 0, 0, 20, (Component)configEntry.getNameComponent(), VALUE_COMPONENT_PROVIDER, VALUES, MusicFrequencyValue.getClosestFromTicks(configEntry.getValue()), (index, value) -> {
            configEntry.setValue(value.ticks);
            if (onValueChanged != null) {
                onValueChanged.accept((Integer)index, (MusicFrequencyValue)value);
            }
        });
    }

    public static MusicFrequencyValue getClosestFromTicks(int ticks) {
        MusicFrequencyValue closestValue = null;
        int closestDistance = -1;
        for (MusicFrequencyValue value : VALUES) {
            int distance = Math.abs(value.ticks - ticks);
            if (closestDistance >= 0 && distance >= closestDistance) break;
            closestDistance = distance;
            closestValue = value;
        }
        return closestValue;
    }

    private MusicFrequencyValue(int value, boolean isMinutes) {
        this.ticks = value * 20 * (isMinutes ? 60 : 1);
        this.valueComponent = Component.literal((String)(value + " ")).append(isMinutes ? SUFFIX_MINUTES : SUFFIX_SECONDS);
    }
}

