/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.function.Consumer;
import namelessju.audioimprovements.common.config.Config;
import namelessju.audioimprovements.common.config.ConfigEntry;
import namelessju.audioimprovements.common.gui.IntegerSlider;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class IntegerEntry
extends ConfigEntry<IntegerEntry> {
    private final int defaultValue;
    private int value;
    public final int minValue;
    public final int maxValue;

    public IntegerEntry(Config config, String key, int defaultValue, int minValue, int maxValue) {
        super(config, key);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = this.defaultValue = defaultValue;
    }

    public void setValue(int value) {
        this.value = Mth.clamp((int)value, (int)this.minValue, (int)this.maxValue);
    }

    public int getValue() {
        return this.value;
    }

    @Override
    protected IntegerEntry getThis() {
        return this;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public boolean loadFromJsonElement(JsonElement element) {
        JsonPrimitive primitive;
        if (element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isNumber()) {
            this.setValue(primitive.getAsInt());
            return true;
        }
        return false;
    }

    @Override
    public JsonElement saveToJsonElement() {
        return new JsonPrimitive((Number)this.value);
    }

    public IntegerSlider createSlider(int x, int y, int width, Consumer<Integer> onValueChange) {
        return new IntegerSlider(x, y, width, 20, (Component)this.getNameComponent(), this.minValue, this.maxValue, this.value, newValue -> {
            this.value = newValue;
            if (onValueChange != null) {
                onValueChange.accept(this.value);
            }
        });
    }
}

