/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.config;

import namelessju.audioimprovements.common.config.Config;
import namelessju.audioimprovements.common.config.IJsonSavable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigEntry<T extends ConfigEntry<T>>
implements IJsonSavable {
    public final String key;
    private boolean hasTooltip = false;

    protected ConfigEntry(Config config, String key) {
        this.key = key;
        config.addEntry(this);
    }

    protected abstract T getThis();

    public T withTooltip() {
        this.hasTooltip = true;
        return this.getThis();
    }

    public MutableComponent getTranslatableComponent(@Nullable String subKey) {
        String translationKey = "audioimprovements.config.option." + this.key;
        if (subKey != null) {
            translationKey = translationKey + "." + subKey;
        }
        return Component.translatable((String)translationKey);
    }

    public MutableComponent getNameComponent() {
        return this.getTranslatableComponent(null);
    }

    public MutableComponent getTooltipComponent() {
        if (!this.hasTooltip) {
            return null;
        }
        return this.getTranslatableComponent("tooltip");
    }

    public abstract void reset();
}

