/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.config;

import com.google.common.base.Charsets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import namelessju.audioimprovements.common.AudioImprovements;
import namelessju.audioimprovements.common.config.ConfigEntry;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public abstract class Config
implements Iterable<ConfigEntry<?>> {
    public final File file;
    private final List<ConfigEntry<?>> entries = new ArrayList();

    public Config(Path configDir, String fileName) {
        this.file = configDir.resolve(fileName.replaceAll("[\\\\/]", "")).toFile();
    }

    void addEntry(ConfigEntry<?> entry) {
        this.entries.add(entry);
    }

    public void load() {
        JsonElement json;
        BufferedReader reader;
        if (!this.file.exists()) {
            for (ConfigEntry<?> entry : this) {
                entry.reset();
            }
            this.save();
            return;
        }
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), Charsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            AudioImprovements.LOGGER.error("Error while loading config: File not found");
            return;
        }
        try {
            json = JsonParser.parseReader((Reader)reader);
        }
        catch (Exception e) {
            AudioImprovements.LOGGER.error("Error while loading config: Failed to parse JSON");
            return;
        }
        boolean missingKeyFound = false;
        JsonObject jsonObject = json.getAsJsonObject();
        for (ConfigEntry<?> entry : this) {
            JsonElement element = jsonObject.get(entry.key);
            if (element != null) {
                if (entry.loadFromJsonElement(element)) continue;
                this.logInvalidEntryValue(entry, element.toString());
            } else {
                missingKeyFound = true;
            }
            entry.reset();
        }
        if (missingKeyFound) {
            this.save();
            AudioImprovements.LOGGER.info("Added missing config key(s) to file");
        }
    }

    protected void logInvalidEntryValue(ConfigEntry<?> entry, String details) {
        AudioImprovements.LOGGER.warn("Invalid value in config file for entry \"{}\": {}", (Object)entry.key, (Object)details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void save() {
        block8: {
            JsonObject json = new JsonObject();
            for (ConfigEntry<?> entry : this) {
                json.add(entry.key, entry.saveToJsonElement());
            }
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), Charsets.UTF_8));
                JsonWriter jsonWriter = new JsonWriter((Writer)writer);
                jsonWriter.setIndent("    ");
                Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
                IOUtils.closeQuietly((Writer)writer);
            }
            catch (FileNotFoundException e) {
                AudioImprovements.LOGGER.error("Error while saving config: Invalid or unwritable file");
            }
            catch (IOException e2) {
                AudioImprovements.LOGGER.error("Error while saving config: Failed to write file");
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(writer);
            }
        }
    }

    @Override
    @NotNull
    public Iterator<ConfigEntry<?>> iterator() {
        return this.entries.iterator();
    }
}

