/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.function.Consumer;
import namelessju.audioimprovements.common.config.Config;
import namelessju.audioimprovements.common.config.ConfigEntry;
import namelessju.audioimprovements.common.gui.WidgetFactory;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BooleanEntry
extends ConfigEntry<BooleanEntry> {
    private final boolean defaultValue;
    public boolean isEnabled;

    public BooleanEntry(Config config, String key, boolean defaultValue) {
        super(config, key);
        this.isEnabled = this.defaultValue = defaultValue;
    }

    @Override
    protected BooleanEntry getThis() {
        return this;
    }

    @Override
    public void reset() {
        this.isEnabled = this.defaultValue;
    }

    @Override
    public boolean loadFromJsonElement(JsonElement element) {
        JsonPrimitive primitive;
        if (element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isBoolean()) {
            this.isEnabled = primitive.getAsBoolean();
            return true;
        }
        return false;
    }

    @Override
    public JsonElement saveToJsonElement() {
        return new JsonPrimitive(Boolean.valueOf(this.isEnabled));
    }

    public CycleButton<Boolean> createButton(int x, int y, int width, Consumer<Boolean> onValueChange) {
        return WidgetFactory.buildBooleanButton(x, y, width, 20, (Component)this.getNameComponent(), this.isEnabled, builder -> builder.withTooltip(unused -> {
            MutableComponent tooltipComponent = this.getTooltipComponent();
            return tooltipComponent != null ? Tooltip.create((Component)tooltipComponent) : null;
        }), (button, value) -> {
            this.isEnabled = value;
            if (onValueChange != null) {
                onValueChange.accept((Boolean)value);
            }
        });
    }
}

