/*
 * Decompiled with CFR 0.152.
 */
package namelessju.audioimprovements.common;

import com.mojang.blaze3d.audio.Channel;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import namelessju.audioimprovements.common.ConfigImpl;
import namelessju.audioimprovements.common.data.SoundChannelType;
import namelessju.audioimprovements.common.gui.ConfigScreen;
import namelessju.audioimprovements.common.mixinaccessors.SoundChannelMixinAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AudioImprovements {
    public static final String MOD_ID = "audioimprovements";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"audioimprovements");
    private static AudioImprovements instance;
    public boolean openConfigNextTick = false;
    public final Set<Channel> musicBlockChannels = new HashSet<Channel>();
    public float musicVolumeMultiplier = 1.0f;
    @Nullable
    public ResourceLocation lastPlayedMusic = null;
    public final ConfigImpl config = new ConfigImpl(this.getConfigDir());

    public static AudioImprovements getInstance() {
        return instance;
    }

    public AudioImprovements() {
        instance = this;
    }

    protected void init() {
        this.config.load();
    }

    public Screen createConfigScreen(Screen parent) {
        return new ConfigScreen(parent, this.config);
    }

    public boolean isSoundTypeMono(@Nullable SoundChannelType type) {
        if (type == null) {
            return false;
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case SoundChannelType.MUSIC_DISC -> this.config.monoMusicDiscs.isEnabled;
            case SoundChannelType.NOTE_BLOCK -> this.config.monoNoteBlocks.isEnabled;
            case SoundChannelType.WEATHER -> this.config.monoWeather.isEnabled;
            case SoundChannelType.BLOCKS -> this.config.monoBlocks.isEnabled;
            case SoundChannelType.HOSTILE -> this.config.monoHostile.isEnabled;
            case SoundChannelType.NEUTRAL -> this.config.monoNeutral.isEnabled;
            case SoundChannelType.PLAYERS -> this.config.monoPlayers.isEnabled;
            case SoundChannelType.AMBIENT -> this.config.monoAmbient.isEnabled;
        };
    }

    public float getAttenuationMultiplier(@Nullable SoundChannelType type) {
        if (type == SoundChannelType.MUSIC_DISC) {
            int value = this.config.maxDistancePercentMusicDiscs.getValue();
            if (value > 300) {
                return -1.0f;
            }
            return (float)value / 100.0f;
        }
        return 1.0f;
    }

    public boolean shouldFadeMusic() {
        Vec3 listenerPos = Minecraft.getInstance().getSoundManager().getListenerTransform().position();
        block4: for (Channel channel : this.musicBlockChannels) {
            Vec3 pos;
            if (!channel.playing()) continue;
            SoundChannelMixinAccessor mixinAccessor = (SoundChannelMixinAccessor)channel;
            switch (mixinAccessor.audioImprovements$getSoundType()) {
                case MUSIC_DISC: {
                    if (this.config.fadeMusicWhenMusicDiscPlaying.isEnabled) break;
                    continue block4;
                }
                case NOTE_BLOCK: {
                    if (this.config.fadeMusicWhenNoteBlockPlaying.isEnabled) break;
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
            if ((pos = mixinAccessor.audioImprovements$getPos()) == null || !(listenerPos.distanceTo(pos) < (double)(0.95f * mixinAccessor.audioImprovements$getMaxDistance()))) continue;
            return true;
        }
        return false;
    }

    protected abstract Path getConfigDir();
}

