/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import link.e4mc.Mirror;
import link.e4mc.QuiclimeSession;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E4mcClient {
    public static final String MOD_ID = "luna_minecraft";
    public static QuiclimeSession session;
    private static final Logger LOGGER;

    public static void init() {
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"luna").requires(src -> {
            if (src.getServer().isDedicatedServer()) {
                return src.hasPermission(4);
            }
            try {
                return src.getServer().isSingleplayerOwner(src.getPlayerOrException().getGameProfile());
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).then(Commands.literal((String)"stop").executes(ctx -> {
            if (session != null && E4mcClient.session.state != QuiclimeSession.State.STOPPED) {
                session.stop();
                Mirror.sendSuccessToSource((CommandSourceStack)ctx.getSource(), Mirror.translatable("text.e4mc_minecraft.closeServer", new Object[0]));
            } else {
                Mirror.sendFailureToSource((CommandSourceStack)ctx.getSource(), Mirror.translatable("text.e4mc_minecraft.serverAlreadyClosed", new Object[0]));
            }
            return 1;
        }))).then(Commands.literal((String)"restart").executes(ctx -> {
            if (session != null && E4mcClient.session.state != QuiclimeSession.State.STARTED) {
                session.stop();
                session = new QuiclimeSession();
                session.startAsync();
            }
            return 1;
        })));
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }
}

