/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.item;

import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.GraveStatus;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GraveKeyItem
extends Item {
    public GraveKeyItem(Item.Properties properties) {
        super(properties);
    }

    public void onCraftedBy(@NotNull ItemStack stack, Level world, @NotNull Player player) {
        if (!world.isClientSide) {
            this.bindStackToLatestGrave(player, stack);
        }
        super.onCraftedBy(stack, world, player);
    }

    public boolean isEnabled(@NotNull FeatureFlagSet enabledFeatures) {
        return YigdConfig.getConfig().extraFeatures.graveKeys.enabled;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player user, @NotNull InteractionHand hand) {
        ItemStack key;
        if (level.isClientSide) {
            return super.use(level, user, hand);
        }
        YigdConfig config = YigdConfig.getConfig();
        if (config.extraFeatures.graveKeys.rebindable && user.isShiftKeyDown() && this.bindStackToLatestGrave(user, key = user.getItemInHand(hand))) {
            return InteractionResultHolder.sidedSuccess((Object)key, (boolean)true);
        }
        return super.use(level, user, hand);
    }

    public boolean bindStackToLatestGrave(Player player, ItemStack key) {
        ResolvableProfile playerProfile = new ResolvableProfile(player.getGameProfile());
        ArrayList<GraveComponent> graves = new ArrayList<GraveComponent>(DeathInfoManager.INSTANCE.getBackupData(playerProfile));
        graves.removeIf(component -> component.getStatus() != GraveStatus.UNCLAIMED);
        int size = graves.size();
        if (size >= 1) {
            GraveComponent component2 = (GraveComponent)graves.get(size - 1);
            this.bindStackToGrave(component2.getGraveId(), playerProfile, key);
            return true;
        }
        return false;
    }

    public void bindStackToGrave(UUID graveId, ResolvableProfile playerProfile, ItemStack key) {
        key.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, comp -> comp.update(nbtCompound -> {
            nbtCompound.put("grave", (Tag)NbtUtils.createUUID((UUID)graveId));
            nbtCompound.put("user", (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)playerProfile).getOrThrow());
        }));
    }
}

