/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.data.GraveItem;
import com.b1n_ry.yigd.events.YigdEvents;
import com.b1n_ry.yigd.util.DropRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosCompat
implements InvModCompat<Map<String, CuriosSlotEntry>> {
    @Override
    public String getModName() {
        return "curios";
    }

    @Override
    public void clear(ServerPlayer player) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            for (ICurioStacksHandler stacksHandler : handler.getCurios().values()) {
                IDynamicStackHandler[] stackHandlers;
                for (IDynamicStackHandler dynamicStackHandler : stackHandlers = new IDynamicStackHandler[]{stacksHandler.getStacks(), stacksHandler.getCosmeticStacks()}) {
                    for (int i = 0; i < dynamicStackHandler.getSlots(); ++i) {
                        dynamicStackHandler.setStackInSlot(i, ItemStack.EMPTY);
                    }
                }
            }
        });
    }

    @Override
    public CompatComponent<Map<String, CuriosSlotEntry>> readNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        HashMap<String, CuriosSlotEntry> inventory = new HashMap<String, CuriosSlotEntry>();
        for (String key : nbt.getAllKeys()) {
            CompoundTag slotNbt = nbt.getCompound(key);
            NonNullList<GraveItem> normalSlot = InventoryComponent.listFromNbt(slotNbt.getCompound("normal"), itemNbt -> {
                String dropRuleString;
                ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)itemNbt).orElse(ItemStack.EMPTY);
                DropRule dropRule = itemNbt.contains("dropRule") ? ((dropRuleString = itemNbt.getString("dropRule")).equals("DEFAULT") ? YigdConfig.getConfig().compatConfig.defaultCuriosDropRule : DropRule.valueOf(dropRuleString)) : YigdConfig.getConfig().compatConfig.defaultCuriosDropRule;
                return new GraveItem(stack, dropRule);
            }, InventoryComponent.EMPTY_GRAVE_ITEM);
            NonNullList<GraveItem> cosmeticSlot = InventoryComponent.listFromNbt(slotNbt.getCompound("cosmetic"), itemNbt -> {
                String dropRuleString;
                ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)itemNbt).orElse(ItemStack.EMPTY);
                DropRule dropRule = itemNbt.contains("dropRule") ? ((dropRuleString = itemNbt.getString("dropRule")).equals("DEFAULT") ? YigdConfig.getConfig().compatConfig.defaultCuriosDropRule : DropRule.valueOf(dropRuleString)) : YigdConfig.getConfig().compatConfig.defaultCuriosDropRule;
                return new GraveItem(stack, dropRule);
            }, InventoryComponent.EMPTY_GRAVE_ITEM);
            inventory.put(key, new CuriosSlotEntry(normalSlot, cosmeticSlot));
        }
        return new CuriosCompatComponent((Map<String, CuriosSlotEntry>)inventory);
    }

    @Override
    public CompatComponent<Map<String, CuriosSlotEntry>> getNewComponent(ServerPlayer player) {
        return new CuriosCompatComponent(player);
    }

    public record CuriosSlotEntry(NonNullList<GraveItem> normal, NonNullList<GraveItem> cosmetic) {
        private void addAllNonEmptyToList(Collection<GraveItem> list) {
            this.addAllNonEmptyToList(list, graveItem -> graveItem);
        }

        private void addAllNonEmptyToStackList(Collection<ItemStack> list) {
            this.addAllNonEmptyToList(list, graveItem -> graveItem.stack);
        }

        private <T> void addAllNonEmptyToList(Collection<T> list, Function<GraveItem, T> mapFunc) {
            for (GraveItem graveItem : this.normal) {
                if (graveItem.stack.isEmpty()) continue;
                list.add(mapFunc.apply(graveItem.copy()));
            }
            for (GraveItem graveItem : this.cosmetic) {
                if (graveItem.stack.isEmpty()) continue;
                list.add(mapFunc.apply(graveItem.copy()));
            }
        }
    }

    private static class CuriosCompatComponent
    extends CompatComponent<Map<String, CuriosSlotEntry>> {
        public CuriosCompatComponent(ServerPlayer player) {
            super(player);
        }

        public CuriosCompatComponent(Map<String, CuriosSlotEntry> inventory) {
            super(inventory);
        }

        @Override
        public Map<String, CuriosSlotEntry> getInventory(ServerPlayer player) {
            HashMap<String, CuriosSlotEntry> inventory = new HashMap<String, CuriosSlotEntry>();
            Optional optionalHandler = CuriosApi.getCuriosInventory((LivingEntity)player);
            if (optionalHandler.isEmpty()) {
                return inventory;
            }
            for (Map.Entry entry : ((ICuriosItemHandler)optionalHandler.get()).getCurios().entrySet()) {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                NonNullList normalItems = NonNullList.create();
                NonNullList cosmeticItems = NonNullList.create();
                IDynamicStackHandler normalEquipped = stacksHandler.getStacks();
                for (int i = 0; i < normalEquipped.getSlots(); ++i) {
                    normalItems.add((Object)new GraveItem(normalEquipped.getStackInSlot(i).copy(), DropRule.PUT_IN_GRAVE));
                }
                IDynamicStackHandler cosmeticEquipped = stacksHandler.getCosmeticStacks();
                for (int i = 0; i < cosmeticEquipped.getSlots(); ++i) {
                    cosmeticItems.add((Object)new GraveItem(cosmeticEquipped.getStackInSlot(i).copy(), DropRule.PUT_IN_GRAVE));
                }
                inventory.put((String)entry.getKey(), new CuriosSlotEntry((NonNullList<GraveItem>)normalItems, (NonNullList<GraveItem>)cosmeticItems));
            }
            return inventory;
        }

        @Override
        public NonNullList<GraveItem> merge(CompatComponent<?> mergingComponent, ServerPlayer merger) {
            NonNullList extraItems = NonNullList.create();
            Map mergingInventory = (Map)mergingComponent.inventory;
            for (Map.Entry entry : mergingInventory.entrySet()) {
                ItemStack thisStack;
                GraveItem currentGraveItem;
                ItemStack mergingStack;
                GraveItem mergingGraveItem;
                int i;
                String key = (String)entry.getKey();
                if (!((Map)this.inventory).containsKey(key)) {
                    ((CuriosSlotEntry)entry.getValue()).addAllNonEmptyToList((Collection<GraveItem>)extraItems);
                    continue;
                }
                CuriosSlotEntry mergingSlot = (CuriosSlotEntry)entry.getValue();
                CuriosSlotEntry thisSlot = (CuriosSlotEntry)((Map)this.inventory).get(key);
                for (i = 0; i < mergingSlot.normal.size(); ++i) {
                    mergingGraveItem = ((GraveItem)mergingSlot.normal.get(i)).copy();
                    mergingStack = mergingGraveItem.stack;
                    if (mergingStack.isEmpty()) continue;
                    if (thisSlot.normal.size() <= i) {
                        extraItems.add((Object)mergingGraveItem);
                        continue;
                    }
                    currentGraveItem = (GraveItem)thisSlot.normal.get(i);
                    thisStack = currentGraveItem.stack;
                    if (YigdConfig.getConfig().graveConfig.treatBindingCurse && this.blockUnequip(mergingStack, key, i, merger, false)) {
                        extraItems.add((Object)currentGraveItem);
                        thisSlot.normal.set(i, (Object)mergingGraveItem);
                        continue;
                    }
                    if (!thisStack.isEmpty()) {
                        extraItems.add((Object)mergingGraveItem);
                        continue;
                    }
                    thisSlot.normal.set(i, (Object)mergingGraveItem);
                }
                for (i = 0; i < mergingSlot.cosmetic.size(); ++i) {
                    mergingGraveItem = ((GraveItem)mergingSlot.cosmetic.get(i)).copy();
                    mergingStack = mergingGraveItem.stack;
                    if (mergingStack.isEmpty()) continue;
                    if (thisSlot.cosmetic.size() <= i) {
                        extraItems.add((Object)mergingGraveItem);
                        continue;
                    }
                    currentGraveItem = (GraveItem)thisSlot.cosmetic.get(i);
                    thisStack = currentGraveItem.stack;
                    if (YigdConfig.getConfig().graveConfig.treatBindingCurse && this.blockUnequip(mergingStack, key, i, merger, true)) {
                        extraItems.add((Object)currentGraveItem);
                        thisSlot.cosmetic.set(i, (Object)mergingGraveItem);
                        continue;
                    }
                    if (!thisStack.isEmpty()) {
                        extraItems.add((Object)mergingGraveItem);
                        continue;
                    }
                    thisSlot.cosmetic.set(i, (Object)mergingGraveItem);
                }
            }
            return extraItems;
        }

        @Override
        public NonNullList<ItemStack> pullBindingCurseItems(ServerPlayer playerRef) {
            NonNullList noUnequipItems = NonNullList.create();
            if (!YigdConfig.getConfig().graveConfig.treatBindingCurse) {
                return noUnequipItems;
            }
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                boolean isBound;
                ItemStack stack;
                GraveItem graveItem;
                int i;
                CuriosSlotEntry inventorySlot = (CuriosSlotEntry)entry.getValue();
                for (i = 0; i < inventorySlot.normal.size(); ++i) {
                    graveItem = (GraveItem)inventorySlot.normal.get(i);
                    stack = graveItem.stack;
                    isBound = this.blockUnequip(stack, (String)entry.getKey(), i, playerRef, false);
                    if (!isBound) continue;
                    noUnequipItems.add((Object)stack);
                    graveItem.stack = ItemStack.EMPTY;
                }
                for (i = 0; i < inventorySlot.cosmetic.size(); ++i) {
                    graveItem = (GraveItem)inventorySlot.cosmetic.get(i);
                    stack = graveItem.stack;
                    isBound = this.blockUnequip(stack, (String)entry.getKey(), i, playerRef, true);
                    if (!isBound) continue;
                    noUnequipItems.add((Object)stack);
                    graveItem.stack = ItemStack.EMPTY;
                }
            }
            return noUnequipItems;
        }

        private boolean blockUnequip(ItemStack stack, String key, int index, ServerPlayer playerRef, boolean cosmetic) {
            Optional iCurio = CuriosApi.getCurio((ItemStack)stack);
            return iCurio.map(curio -> curio.canUnequip(new SlotContext(key, (LivingEntity)playerRef, index, cosmetic, false))).orElse(true) == false;
        }

        @Override
        public NonNullList<ItemStack> storeToPlayer(ServerPlayer player) {
            NonNullList extraItems = NonNullList.create();
            Optional optional = CuriosApi.getCuriosInventory((LivingEntity)player);
            if (optional.isEmpty()) {
                return extraItems;
            }
            Map stacksHandlerMap = ((ICuriosItemHandler)optional.get()).getCurios();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                GraveItem graveItem;
                int i;
                String key = (String)entry.getKey();
                if (!stacksHandlerMap.containsKey(key)) {
                    ((CuriosSlotEntry)entry.getValue()).addAllNonEmptyToStackList((Collection<ItemStack>)extraItems);
                    continue;
                }
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)stacksHandlerMap.get(key);
                CuriosSlotEntry slotEntry = (CuriosSlotEntry)entry.getValue();
                IDynamicStackHandler normalEquipped = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticEquipped = stacksHandler.getCosmeticStacks();
                for (i = 0; i < slotEntry.normal.size(); ++i) {
                    graveItem = ((GraveItem)slotEntry.normal.get(i)).copy();
                    if (i >= normalEquipped.getSlots()) {
                        extraItems.add((Object)graveItem.stack);
                        continue;
                    }
                    normalEquipped.setStackInSlot(i, graveItem.stack);
                }
                for (i = 0; i < slotEntry.cosmetic.size(); ++i) {
                    graveItem = ((GraveItem)slotEntry.cosmetic.get(i)).copy();
                    if (i >= cosmeticEquipped.getSlots()) {
                        extraItems.add((Object)graveItem.stack);
                        continue;
                    }
                    cosmeticEquipped.setStackInSlot(i, graveItem.stack);
                }
            }
            return extraItems;
        }

        private ICurio.DropRule getDropRule(ItemStack stack, String key, int index, DeathContext context, boolean cosmetic, List<Tuple<Predicate<ItemStack>, ICurio.DropRule>> overrides) {
            for (Tuple<Predicate<ItemStack>, ICurio.DropRule> t : overrides) {
                if (!((Predicate)t.getA()).test(stack)) continue;
                return (ICurio.DropRule)t.getB();
            }
            Optional iCurio = CuriosApi.getCurio((ItemStack)stack);
            return iCurio.map(curio -> curio.getDropRule(new SlotContext(key, (LivingEntity)context.player(), index, cosmetic, false), context.deathSource(), true)).orElse(ICurio.DropRule.DEFAULT);
        }

        @Override
        public void handleDropRules(DeathContext context) {
            ServerPlayer player = context.player();
            ArrayList<Tuple<Predicate<ItemStack>, ICurio.DropRule>> overrides = new ArrayList<Tuple<Predicate<ItemStack>, ICurio.DropRule>>();
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                DropRulesEvent event = (DropRulesEvent)NeoForge.EVENT_BUS.post((Event)new DropRulesEvent((LivingEntity)player, handler, context.deathSource(), 0, false));
                overrides.addAll((Collection<Tuple<Predicate<ItemStack>, ICurio.DropRule>>)event.getOverrides());
            });
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                DropRule defaultDropRule;
                ItemStack stack;
                GraveItem graveItem;
                int i;
                String key = (String)entry.getKey();
                CuriosSlotEntry inventorySlot = (CuriosSlotEntry)entry.getValue();
                for (i = 0; i < inventorySlot.normal.size(); ++i) {
                    graveItem = (GraveItem)inventorySlot.normal.get(i);
                    stack = graveItem.stack;
                    graveItem.dropRule = switch (this.getDropRule(stack, key, i, context, false, overrides)) {
                        case ICurio.DropRule.DESTROY -> DropRule.DESTROY;
                        case ICurio.DropRule.ALWAYS_KEEP -> DropRule.KEEP;
                        default -> {
                            defaultDropRule = YigdConfig.getConfig().compatConfig.defaultCuriosDropRule;
                            if (defaultDropRule == DropRule.PUT_IN_GRAVE) {
                                yield ((YigdEvents.DropRuleEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.DropRuleEvent(stack, -1, context, true))).getDropRule();
                            }
                            yield defaultDropRule;
                        }
                    };
                }
                for (i = 0; i < inventorySlot.cosmetic.size(); ++i) {
                    graveItem = (GraveItem)inventorySlot.cosmetic.get(i);
                    stack = graveItem.stack;
                    graveItem.dropRule = switch (this.getDropRule(stack, key, i, context, true, overrides)) {
                        case ICurio.DropRule.DESTROY -> DropRule.DESTROY;
                        case ICurio.DropRule.ALWAYS_KEEP -> DropRule.KEEP;
                        default -> {
                            defaultDropRule = YigdConfig.getConfig().compatConfig.defaultCuriosDropRule;
                            if (defaultDropRule == DropRule.PUT_IN_GRAVE) {
                                yield ((YigdEvents.DropRuleEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.DropRuleEvent(stack, -1, context, true))).getDropRule();
                            }
                            yield defaultDropRule;
                        }
                    };
                }
            }
        }

        @Override
        public NonNullList<GraveItem> getAsGraveItemList() {
            NonNullList allItems = NonNullList.create();
            for (CuriosSlotEntry slotEntry : ((Map)this.inventory).values()) {
                allItems.addAll(slotEntry.normal);
                allItems.addAll(slotEntry.cosmetic);
            }
            return allItems;
        }

        @Override
        public CompatComponent<Map<String, CuriosSlotEntry>> filterInv(Predicate<DropRule> predicate) {
            HashMap<String, CuriosSlotEntry> filtered = new HashMap<String, CuriosSlotEntry>();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                CuriosSlotEntry inventorySlot = (CuriosSlotEntry)entry.getValue();
                NonNullList normalSlot = NonNullList.create();
                NonNullList cosmeticSlot = NonNullList.create();
                for (GraveItem graveItem : inventorySlot.normal) {
                    if (predicate.test(graveItem.dropRule)) {
                        normalSlot.add((Object)graveItem);
                        continue;
                    }
                    normalSlot.add((Object)InventoryComponent.EMPTY_GRAVE_ITEM);
                }
                for (GraveItem graveItem : inventorySlot.cosmetic) {
                    if (predicate.test(graveItem.dropRule)) {
                        cosmeticSlot.add((Object)graveItem);
                        continue;
                    }
                    cosmeticSlot.add((Object)InventoryComponent.EMPTY_GRAVE_ITEM);
                }
                filtered.put((String)entry.getKey(), new CuriosSlotEntry((NonNullList<GraveItem>)normalSlot, (NonNullList<GraveItem>)cosmeticSlot));
            }
            return new CuriosCompatComponent((Map<String, CuriosSlotEntry>)filtered);
        }

        @Override
        public boolean removeItem(Predicate<ItemStack> predicate, int itemCount) {
            for (CuriosSlotEntry inventorySlot : ((Map)this.inventory).values()) {
                for (GraveItem graveItem : inventorySlot.normal) {
                    ItemStack stack = graveItem.stack;
                    if (!predicate.test(stack)) continue;
                    stack.shrink(itemCount);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            for (CuriosSlotEntry inventorySlot : ((Map)this.inventory).values()) {
                Collections.fill(inventorySlot.normal, InventoryComponent.EMPTY_GRAVE_ITEM);
                Collections.fill(inventorySlot.cosmetic, InventoryComponent.EMPTY_GRAVE_ITEM);
            }
        }

        @Override
        public CompoundTag writeNbt(HolderLookup.Provider registries) {
            CompoundTag nbt = new CompoundTag();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                CuriosSlotEntry inventorySlot = (CuriosSlotEntry)entry.getValue();
                CompoundTag slotNbt = new CompoundTag();
                CompoundTag normalNbt = InventoryComponent.listToNbt(inventorySlot.normal, graveItem -> {
                    CompoundTag itemNbt = (CompoundTag)graveItem.stack.save(registries);
                    itemNbt.putString("dropRule", graveItem.dropRule.name());
                    return itemNbt;
                }, graveItem -> graveItem.stack.isEmpty());
                CompoundTag cosmeticNbt = InventoryComponent.listToNbt(inventorySlot.cosmetic, graveItem -> {
                    CompoundTag itemNbt = (CompoundTag)graveItem.stack.save(registries);
                    itemNbt.putString("dropRule", graveItem.dropRule.name());
                    return itemNbt;
                }, graveItem -> graveItem.stack.isEmpty());
                slotNbt.put("normal", (Tag)normalNbt);
                slotNbt.put("cosmetic", (Tag)cosmeticNbt);
                nbt.put((String)entry.getKey(), (Tag)slotNbt);
            }
            return nbt;
        }
    }
}

