/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import java.util.Iterator;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.element.MapElementRenderProvider;
import xaero.map.element.render.ElementRenderLocation;
import xaero.map.mods.SupportXaeroMinimap;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointRenderContext;

public class WaypointRenderProvider
extends MapElementRenderProvider<Waypoint, WaypointRenderContext> {
    private final SupportXaeroMinimap minimap;
    private Iterator<Waypoint> iterator;

    public WaypointRenderProvider(SupportXaeroMinimap minimap) {
        this.minimap = minimap;
    }

    @Override
    public void begin(ElementRenderLocation location, WaypointRenderContext context) {
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        if (!((Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINTS)).booleanValue() || this.minimap.getWaypoints() == null) {
            this.iterator = null;
            return;
        }
        this.iterator = this.minimap.getWaypoints().iterator();
        context.worldmapWaypointsScale = (float)((Double)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINT_SCALE)).doubleValue();
        context.waypointBackgrounds = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINT_BACKGROUNDS);
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        context.showDisabledWaypoints = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.DISPLAY_DISABLED_WAYPOINTS);
    }

    @Override
    public boolean hasNext(ElementRenderLocation location, WaypointRenderContext context) {
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    public Waypoint getNext(ElementRenderLocation location, WaypointRenderContext context) {
        return this.iterator.next();
    }

    @Override
    public void end(ElementRenderLocation location, WaypointRenderContext context) {
    }

    @Override
    @Deprecated
    public void begin(int location, WaypointRenderContext context) {
        this.begin(ElementRenderLocation.fromIndex(location), context);
    }

    @Override
    @Deprecated
    public boolean hasNext(int location, WaypointRenderContext context) {
        return this.hasNext(ElementRenderLocation.fromIndex(location), context);
    }

    @Override
    @Deprecated
    public Waypoint getNext(int location, WaypointRenderContext context) {
        return this.getNext(ElementRenderLocation.fromIndex(location), context);
    }

    @Override
    @Deprecated
    public Waypoint setupContextAndGetNext(ElementRenderLocation location, WaypointRenderContext context) {
        return this.getNext(location, context);
    }

    @Override
    @Deprecated
    public Waypoint setupContextAndGetNext(int location, WaypointRenderContext context) {
        return this.setupContextAndGetNext(ElementRenderLocation.fromIndex(location), context);
    }

    @Override
    @Deprecated
    public void end(int location, WaypointRenderContext context) {
        this.end(ElementRenderLocation.fromIndex(location), context);
    }
}

