/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.platform;

import com.bawnorton.neruina.platform.ModLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModInfo;

public final class Platform {
    public static ModLoader getModLoader() {
        return ModLoader.NEOFORGE;
    }

    public static String getModVersion(String modid) {
        return ModList.get().getModFileById(modid).versionString();
    }

    public static boolean isModLoaded(String modid) {
        List mods = LoadingModList.get().getMods();
        for (ModInfo mod : mods) {
            if (!mod.getModId().equals(modid)) continue;
            return true;
        }
        return false;
    }

    public static String modidFromJar(String jarName) {
        for (ModInfo mod : LoadingModList.get().getMods()) {
            String modLocation = mod.getOwningFile().getFile().getFilePath().toString().replace("+", " ");
            String decodedJarName = URLDecoder.decode(jarName, StandardCharsets.UTF_8);
            int hashIndex = decodedJarName.lastIndexOf("#");
            if (hashIndex != -1) {
                decodedJarName = decodedJarName.substring(0, hashIndex);
            }
            if (!modLocation.endsWith(decodedJarName)) continue;
            return mod.getModId();
        }
        return null;
    }

    public static String getVersion() {
        return FMLLoader.versionInfo().neoForgeVersion();
    }

    public static boolean isClient() {
        return FMLLoader.getDist().isClient();
    }

    public static boolean isDev() {
        return !FMLLoader.isProduction();
    }
}

