/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin.errorable;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.extend.Errorable;
import com.bawnorton.neruina.handler.MessageHandler;
import com.bawnorton.neruina.util.TickingEntry;
import com.bawnorton.neruina.version.Texter;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
abstract class EntityMixin
implements Errorable {
    @Shadow
    private Level level;
    @Unique
    private boolean neruina$errored = false;
    @Unique
    private UUID neruina$tickingEntryId = null;

    EntityMixin() {
    }

    @Shadow
    public abstract Component getName();

    @Shadow
    public abstract Level level();

    @Override
    public boolean neruina$isErrored() {
        return this.neruina$errored;
    }

    @Override
    public void neruina$setErrored() {
        this.neruina$errored = true;
    }

    @Override
    public void neruina$clearErrored() {
        this.neruina$errored = false;
    }

    @Override
    public void neruina$setTickingEntryId(UUID uuid) {
        this.neruina$tickingEntryId = uuid;
    }

    @Override
    public UUID neruina$getTickingEntryId() {
        return this.neruina$tickingEntryId;
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V")})
    private void writeErrored(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        if (this.neruina$errored) {
            tag.putBoolean("neruina$errored", true);
        }
        if (this.neruina$tickingEntryId != null) {
            tag.putString("neruina$tickingEntryId", this.neruina$tickingEntryId.toString());
        }
    }

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setAirSupply(I)V")})
    private void loadAdditional(CompoundTag tag, CallbackInfo ci) {
        this.neruina$errored = tag.getBoolean("neruina$errored");
        if (tag.contains("neruina$tickingEntryId")) {
            this.neruina$tickingEntryId = UUID.fromString(tag.getString("neruina$tickingEntryId"));
        }
    }

    @ModifyReturnValue(method={"isInvulnerableTo", "method_64421", "isInvulnerableToBase"}, at={@At(value="RETURN")})
    private boolean ignoreDamageWhenErrored(boolean original, @Local(argsOnly=true) DamageSource source) {
        if (original) {
            return true;
        }
        if (this.neruina$errored && this.neruina$tickingEntryId != null) {
            Entity entity = source.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                TickingEntry entry = Neruina.getInstance().getTickHandler().getTickingEntry(this.neruina$tickingEntryId);
                MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
                if (entry == null) {
                    messageHandler.sendToPlayer((Player)player, Texter.concatDelimited(Texter.LINE_BREAK, Texter.translatable("neruina.suspended.entity", this.getName().getString()), Texter.translatable("neruina.suspended.entity.untracked", new Object[0])), messageHandler.generateEntityActions((Player)player, (Entity)this), messageHandler.generateInfoAction());
                } else {
                    messageHandler.sendToPlayer((Player)player, Texter.translatable("neruina.suspended.entity", this.getName().getString()), messageHandler.generateEntityActions((Player)player, (Entity)this), messageHandler.generateResourceActions((Player)player, entry));
                }
            }
            return source != this.level.damageSources().genericKill();
        }
        return false;
    }
}

