/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterjungletemples.world.processor;

import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.betterjungletemples.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.betterjungletemples.world.util.ArrowData;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EmptyDispenserProcessor
extends StructureProcessor {
    public static final EmptyDispenserProcessor INSTANCE = new EmptyDispenserProcessor();
    public static final MapCodec<EmptyDispenserProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        ListTag items;
        if (blockInfoGlobal.state().is(Blocks.DISPENSER) && (items = blockInfoGlobal.nbt().getList("Items", 10)).isEmpty()) {
            RandomSource randomSource = structurePlacementData.getRandom(blockInfoGlobal.pos());
            for (int slot = 0; slot < 9; ++slot) {
                ArrowData arrowData = ArrowData.getArrow(randomSource, 0.2f, 0.1f);
                if (arrowData == ArrowData.EMPTY) continue;
                CompoundTag slotTag = new CompoundTag();
                slotTag.putByte("Slot", (byte)slot);
                slotTag.putString("id", arrowData.getId());
                slotTag.putByte("Count", (byte)1);
                if (arrowData.isTipped()) {
                    slotTag.put("components", (Tag)arrowData.getComponentsTag());
                }
                items.add((Object)slotTag);
            }
            blockInfoGlobal.nbt().put("Items", (Tag)items);
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.EMPTY_DISPENSER_PROCESSOR;
    }
}

