/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.worldgen.bloodcap_mushroom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyFoliagePlacers;

@ParametersAreNonnullByDefault
public class BloodcapMushroomFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<BloodcapMushroomFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(parts -> BloodcapMushroomFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)parts).apply((Applicative)parts, BloodcapMushroomFoliagePlacer::new));

    public BloodcapMushroomFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return random.nextInt(4, 6);
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos pos = attachment.pos();
        int leafHeight = foliageHeight - random.nextInt(2, 3);
        for (int i = 0; i < foliageHeight; ++i) {
            this.placeLeavesRow(level, blockSetter, random, config, pos, offset, i - leafHeight, false);
        }
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        float dist = Mth.sqrt((float)(Mth.square((int)localX) + Mth.square((int)localZ)));
        boolean should = false;
        should |= dist > (float)random.nextInt(10, 17 + Mth.abs((int)localY)) / 10.0f;
        if (localY >= 0) {
            int thing = Mth.abs((int)(localY - 1)) + 2;
            should |= dist > (float)(random.nextInt(5, thing * 5) / 10);
        }
        return should;
    }

    protected FoliagePlacerType<?> type() {
        return WetlandWhimsyFoliagePlacers.BLOODCAP_MUSHROOM_FOLIAGE_PLACER.get();
    }
}

