/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.worldgen.bald_cypress;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyTrunkPlacers;

@ParametersAreNonnullByDefault
public class BaldCypressTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<BaldCypressTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> BaldCypressTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, BaldCypressTrunkPlacer::new));

    public BaldCypressTrunkPlacer(int height, int heightRandA, int heightRandB) {
        super(height, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return WetlandWhimsyTrunkPlacers.BALD_CYPRESS_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        TrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        this.root(level, blockSetter, random, pos, config);
        for (int i = 0; i < height; ++i) {
            this.placeLog(level, blockSetter, random, pos.above(i), config);
            if (i <= 2 || i >= height - 2 || i % 2 == 0) continue;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (!(random.nextDouble() < (double)((float)i / (float)height) - 0.25)) continue;
                this.branch(level, blockSetter, random, pos.above(i), dir, config);
            }
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.above(height), 0, false));
    }

    void branch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, Direction dir, TreeConfiguration config) {
        this.placeLog(level, blockSetter, random, pos.relative(dir), config, block -> (BlockState)block.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis()));
    }

    void root(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        int rootPosX = random.nextInt(-1, 1);
        int rootPosZ = random.nextInt(-1, 1);
        BaldCypressTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.offset(rootPosX, -1, rootPosZ), (TreeConfiguration)config);
        for (int i = 0; i < 2; ++i) {
            this.placeLog(level, blockSetter, random, pos.offset(rootPosX, i, rootPosZ), config);
        }
    }
}

