/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.worldgen.bald_cypress;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyFoliagePlacers;

@ParametersAreNonnullByDefault
public class BaldCypressFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<BaldCypressFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(parts -> BaldCypressFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)parts).apply((Applicative)parts, BaldCypressFoliagePlacer::new));

    public BaldCypressFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return random.nextInt(6, 9);
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos pos = attachment.pos();
        int leafHeight = foliageHeight - random.nextInt(2, 4);
        for (int i = 0; i < foliageHeight; ++i) {
            this.placeLeavesRow(level, blockSetter, random, config, pos, offset, i - leafHeight, false);
        }
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return (double)Mth.square((int)localX) + Mth.lerp((double)0.75, (double)localY, (double)((double)range / 1.5)) + (double)Mth.square((int)localZ) > (double)(range + random.nextInt(3));
    }

    protected FoliagePlacerType<?> type() {
        return WetlandWhimsyFoliagePlacers.BALD_CYPRESS_FOLIAGE_PLACER.get();
    }
}

