/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.datagen.registries;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.neoforged.neoforge.common.Tags;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyEntityTypes;
import uwu.juni.wetland_whimsy.datagen.registries.WetlandWhimsyStructurePools;

public class WetlandWhimsyStructures {
    public static final ResourceKey<Structure> ARCH = WetlandWhimsyStructures.createKey("arch");
    public static final ResourceKey<Structure> PILLAR = WetlandWhimsyStructures.createKey("pillar");
    public static final ResourceKey<Structure> WALL = WetlandWhimsyStructures.createKey("wall");
    public static final ResourceKey<Structure> ARENA = WetlandWhimsyStructures.createKey("arena");
    public static final ResourceKey<Structure> SWAMP_DUNGEON = WetlandWhimsyStructures.createKey("swamp_dungeon");
    public static final ResourceKey<Structure> WITCH_HUT = WetlandWhimsyStructures.createKey("witch_hut");
    final Map<MobCategory, StructureSpawnOverride> SWAMP_DUNGEON_SPAWNS = Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(WetlandWhimsyEntityTypes.BLEMISH.get(), 2, 1, 3), new MobSpawnSettings.SpawnerData(WetlandWhimsyEntityTypes.SWAMP_SPIDER.get(), 1, 1, 1), new MobSpawnSettings.SpawnerData(EntityType.BOGGED, 3, 1, 3), new MobSpawnSettings.SpawnerData(EntityType.CAVE_SPIDER, 3, 1, 3), new MobSpawnSettings.SpawnerData(EntityType.DROWNED, 3, 1, 3), new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE, 4, 1, 3), new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 4, 1, 3), new MobSpawnSettings.SpawnerData(EntityType.SPIDER, 3, 1, 2)})));
    final Map<MobCategory, StructureSpawnOverride> WITCH_HUT_SPAWNS = Map.of(MobCategory.CREATURE, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.CAT, 1, 1, 1)})), MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.WITCH, 1, 1, 1)})));
    BootstrapContext<Structure> context;

    public static void bootstap(BootstrapContext<Structure> context) {
        new WetlandWhimsyStructures(context);
    }

    WetlandWhimsyStructures(BootstrapContext<Structure> context) {
        this.context = context;
        this.registerSurfaceStructure(ARCH, WetlandWhimsyStructurePools.ARCH);
        this.registerSurfaceStructure(PILLAR, WetlandWhimsyStructurePools.PILLAR);
        this.registerSurfaceStructure(WALL, WetlandWhimsyStructurePools.WALL);
        this.registerSurfaceStructure(ARENA, WetlandWhimsyStructurePools.ARENA);
        this.registerSurfaceStructure(SWAMP_DUNGEON, WetlandWhimsyStructurePools.SWAMP_DUNGEON_ENTRANCE, ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-2)), new Structure.StructureSettings(this.lookupBiome((TagKey<Biome>)Tags.Biomes.IS_SWAMP), this.SWAMP_DUNGEON_SPAWNS, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE));
        this.registerSurfaceStructure(WITCH_HUT, WetlandWhimsyStructurePools.WITCH_HUT, ConstantHeight.ZERO, new Structure.StructureSettings(this.lookupBiome((TagKey<Biome>)BiomeTags.HAS_SWAMP_HUT), this.WITCH_HUT_SPAWNS, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN));
    }

    void registerSurfaceStructure(ResourceKey<Structure> structure, ResourceKey<StructureTemplatePool> pool) {
        this.registerSurfaceStructure(structure, pool, ConstantHeight.ZERO, new Structure.StructureSettings(this.lookupBiome((TagKey<Biome>)Tags.Biomes.IS_SWAMP), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN));
    }

    void registerSurfaceStructure(ResourceKey<Structure> structure, ResourceKey<StructureTemplatePool> pool, ConstantHeight height, Structure.StructureSettings settings) {
        HolderGetter templatePools = this.context.lookup(Registries.TEMPLATE_POOL);
        this.context.register(structure, (Object)new JigsawStructure(settings, (Holder)templatePools.getOrThrow(pool), Optional.empty(), 16, (HeightProvider)height, false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 100, List.of(), DimensionPadding.ZERO, LiquidSettings.IGNORE_WATERLOGGING));
    }

    HolderSet<Biome> lookupBiome(TagKey<Biome> tag) {
        return this.context.lookup(Registries.BIOME).getOrThrow(tag);
    }

    static ResourceKey<Structure> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)WetlandWhimsy.rLoc(name));
    }
}

