/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.datagen.registries;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.datagen.registries.WetlandWhimsyStructureProcessors;
import uwu.juni.wetland_whimsy.worldgen.SinglePoolElementAccessor;

public class WetlandWhimsyStructurePools {
    public static final ResourceKey<StructureTemplatePool> ARCH = WetlandWhimsyStructurePools.createKey("arch");
    public static final ResourceKey<StructureTemplatePool> PILLAR = WetlandWhimsyStructurePools.createKey("pillar");
    public static final ResourceKey<StructureTemplatePool> WALL = WetlandWhimsyStructurePools.createKey("wall");
    public static final ResourceKey<StructureTemplatePool> ARENA = WetlandWhimsyStructurePools.createKey("arena/arena_base");
    public static final ResourceKey<StructureTemplatePool> SWAMP_DUNGEON_ENTRANCE = WetlandWhimsyStructurePools.createKey("swamp_dungeon/entrance");
    public static final ResourceKey<StructureTemplatePool> SWAMP_DUNGEON_HOLE = WetlandWhimsyStructurePools.createKey("swamp_dungeon/hole");
    public static final ResourceKey<StructureTemplatePool> SWAMP_DUNGEON_ATRIUM = WetlandWhimsyStructurePools.createKey("swamp_dungeon/atrium");
    public static final ResourceKey<StructureTemplatePool> SWAMP_DUNGEON_ROOM = WetlandWhimsyStructurePools.createKey("swamp_dungeon/room");
    public static final ResourceKey<StructureTemplatePool> SWAMP_DUNGEON_ROOM_LOWER = WetlandWhimsyStructurePools.createKey("swamp_dungeon/room_lower");
    public static final ResourceKey<StructureTemplatePool> SWAMP_DUNGEON_SPAWNER = WetlandWhimsyStructurePools.createKey("swamp_dungeon/spawner");
    public static final ResourceKey<StructureTemplatePool> SWAMP_DUNGEON_LOOT = WetlandWhimsyStructurePools.createKey("swamp_dungeon/loot");
    public static final ResourceKey<StructureTemplatePool> SWAMP_DUNGEON_DEAD_END = WetlandWhimsyStructurePools.createKey("swamp_dungeon/dead_end");
    public static final ResourceKey<StructureTemplatePool> WITCH_HUT = WetlandWhimsyStructurePools.createKey("witch_hut/witch_hut");
    public static final ResourceKey<StructureTemplatePool> WITCH = WetlandWhimsyStructurePools.createKey("witch_hut/witch");
    public static final ResourceKey<StructureTemplatePool> CAT = WetlandWhimsyStructurePools.createKey("witch_hut/cat");

    private static ResourceKey<StructureTemplatePool> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)WetlandWhimsy.rLoc(name));
    }

    public static void bootstap(BootstrapContext<StructureTemplatePool> context) {
        Holder.Reference fallback = context.lookup(Registries.TEMPLATE_POOL).getOrThrow(Pools.EMPTY);
        context.register(ARCH, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.pool("arch_1", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.pool("arch_2", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.pool("arch_3", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(PILLAR, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.pool("pillar_1", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.pool("pillar_2", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.pool("pillar_3", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(WALL, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.pool("wall_1", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.pool("wall_2", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.pool("wall_3", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(ARENA, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.pool("arena/arena_1", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.pool("arena/arena_2", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.pool("arena/arena_3", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.pool("arena/arena_4", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(SWAMP_DUNGEON_DEAD_END, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/dead_end_1", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/dead_end_2", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/dead_end_3", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/dead_end_4", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/hole/hole_dead_end", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Holder.Reference fallbackSwampDungeon = context.lookup(Registries.TEMPLATE_POOL).getOrThrow(SWAMP_DUNGEON_DEAD_END);
        context.register(SWAMP_DUNGEON_ENTRANCE, (Object)new StructureTemplatePool((Holder)fallbackSwampDungeon, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.pool("swamp_dungeon/entrance/entrance", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(SWAMP_DUNGEON_HOLE, (Object)new StructureTemplatePool((Holder)fallbackSwampDungeon, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/hole/hole", context), (Object)6), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/hole/hole_dead_end", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(SWAMP_DUNGEON_ATRIUM, (Object)new StructureTemplatePool((Holder)fallbackSwampDungeon, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/atrium/atrium_1", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/atrium/atrium_2", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/atrium/atrium_3", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(SWAMP_DUNGEON_ROOM, (Object)new StructureTemplatePool((Holder)fallbackSwampDungeon, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/combat_room_1", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/combat_room_2", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/combat_room_3", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/combat_room_4", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/combat_room_5", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/combat_room_6", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/combat_room_7", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/combat_room_8", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/combat_room_9", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/combat_room_10", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/dead_end_1", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/dead_end_2", context), (Object)1), (Object[])new Pair[]{Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/dead_end_3", context), (Object)1), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/dead_end_4", context), (Object)1), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/digsite_1", context), (Object)1), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/hallway_1", context), (Object)2), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/hallway_2", context), (Object)2), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/hallway_3", context), (Object)1), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/hallway_4", context), (Object)2), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/hallway_5", context), (Object)2), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/hallway_6", context), (Object)2), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/hallway_7", context), (Object)2), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/hallway_8", context), (Object)2), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/hallway_9", context), (Object)2), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/hallway_10", context), (Object)1), Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room/hallway_11", context), (Object)2)}), StructureTemplatePool.Projection.RIGID));
        context.register(SWAMP_DUNGEON_ROOM_LOWER, (Object)new StructureTemplatePool((Holder)fallbackSwampDungeon, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room_lower/lower_room_1", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room_lower/lower_room_2", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/room_lower/lower_room_3", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(SWAMP_DUNGEON_SPAWNER, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/spawner/regular_brazier", context), (Object)1), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/spawner/ancient_brazier", context), (Object)3)), StructureTemplatePool.Projection.RIGID));
        context.register(SWAMP_DUNGEON_LOOT, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/loot/loot", context), (Object)2), (Object)Pair.of(WetlandWhimsyStructurePools.dungeon_pool("swamp_dungeon/loot/loot_empty", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(WITCH_HUT, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.boring_pool("witch_hut/witch_hut", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(WITCH, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.boring_pool("witch_hut/witch", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(CAT, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of(WetlandWhimsyStructurePools.boring_pool("witch_hut/cat", context), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    private static Function<StructureTemplatePool.Projection, SinglePoolElementAccessor> pool(String id, BootstrapContext<StructureTemplatePool> context) {
        return pool -> new SinglePoolElementAccessor((Either<ResourceLocation, StructureTemplate>)Either.left((Object)WetlandWhimsy.rLoc(id)), (Holder<StructureProcessorList>)context.lookup(Registries.PROCESSOR_LIST).getOrThrow(WetlandWhimsyStructureProcessors.LIMESTONE_RUBBLE), (StructureTemplatePool.Projection)pool, Optional.empty());
    }

    private static Function<StructureTemplatePool.Projection, SinglePoolElementAccessor> dungeon_pool(String id, BootstrapContext<StructureTemplatePool> context) {
        return pool -> new SinglePoolElementAccessor((Either<ResourceLocation, StructureTemplate>)Either.left((Object)WetlandWhimsy.rLoc(id)), (Holder<StructureProcessorList>)context.lookup(Registries.PROCESSOR_LIST).getOrThrow(WetlandWhimsyStructureProcessors.DUNGEON), (StructureTemplatePool.Projection)pool, Optional.empty());
    }

    private static Function<StructureTemplatePool.Projection, SinglePoolElementAccessor> boring_pool(String id, BootstrapContext<StructureTemplatePool> context) {
        return pool -> new SinglePoolElementAccessor((Either<ResourceLocation, StructureTemplate>)Either.left((Object)WetlandWhimsy.rLoc(id)), (Holder<StructureProcessorList>)Holder.direct((Object)new StructureProcessorList(List.of())), (StructureTemplatePool.Projection)pool, Optional.empty());
    }
}

