/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.datagen.registries;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceRelativeThresholdFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.datagen.registries.WetlandWhimsyConfiguredFeatures;

public class WetlandWhimsyPlacedFeatures {
    public static final ResourceKey<PlacedFeature> TREES_BOG = WetlandWhimsyPlacedFeatures.createKey("trees_bog");
    public static final ResourceKey<PlacedFeature> TREES_MARSH = WetlandWhimsyPlacedFeatures.createKey("trees_marsh");
    public static final ResourceKey<PlacedFeature> LIMESTONE_BLOB_SWAMP = WetlandWhimsyPlacedFeatures.createKey("limestone_blob_swamp");
    public static final ResourceKey<PlacedFeature> LIMESTONE_BLOB_MARSH = WetlandWhimsyPlacedFeatures.createKey("limestone_blob_marsh");
    public static final ResourceKey<PlacedFeature> MUD_PATCH_SWAMP = WetlandWhimsyPlacedFeatures.createKey("mud_patch_swamp");
    public static final ResourceKey<PlacedFeature> MUD_PATCH_MARSH = WetlandWhimsyPlacedFeatures.createKey("mud_patch_marsh");
    public static final ResourceKey<PlacedFeature> MUD_POOL_SWAMP = WetlandWhimsyPlacedFeatures.createKey("mud_pool_swamp");
    public static final ResourceKey<PlacedFeature> MUD_POOL_MARSH = WetlandWhimsyPlacedFeatures.createKey("mud_pool_marsh");
    public static final ResourceKey<PlacedFeature> CORDGRASS_PATCH = WetlandWhimsyPlacedFeatures.createKey("cordgrass_patch");
    public static final ResourceKey<PlacedFeature> PENNYWORT_PATCH = WetlandWhimsyPlacedFeatures.createKey("pennywort_patch");
    public static final ResourceKey<PlacedFeature> BLOODCAP_PATCH = WetlandWhimsyPlacedFeatures.createKey("bloodcap_patch");
    public static final ResourceKey<PlacedFeature> BLOODCAP_PATCH_SURFACE = WetlandWhimsyPlacedFeatures.createKey("bloodcap_patch_surface");
    public static final ResourceKey<PlacedFeature> HUGE_ARIA = WetlandWhimsyPlacedFeatures.createKey("huge_aria");
    public static final ResourceKey<PlacedFeature> MUD_BLOB = WetlandWhimsyPlacedFeatures.createKey("mud_blob");
    public static final ResourceKey<PlacedFeature> SUPER_THICK_CORDGRASS_PATCH = WetlandWhimsyPlacedFeatures.createKey("super_thick_cordgrass_patch");
    public static final ResourceKey<PlacedFeature> FERN_CLONE_CAUSE_FUCK_THE_FEATURE_CYCLE = WetlandWhimsyPlacedFeatures.createKey("fern_clone");

    public static void bootstap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(TREES_BOG, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.TREES_BOG), WetlandWhimsyPlacedFeatures.bogTreePlacement()));
        context.register(TREES_MARSH, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.TREES_MARSH), WetlandWhimsyPlacedFeatures.marshTreePlacement()));
        context.register(CORDGRASS_PATCH, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.CORDGRASS_PATCH), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.register(PENNYWORT_PATCH, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.PENNYWORT_PATCH), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.register(BLOODCAP_PATCH, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.BLOODCAP_PATCH), List.of(CountPlacement.of((IntProvider)UniformInt.of((int)20, (int)50)), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, InSquarePlacement.spread(), SurfaceRelativeThresholdFilter.of((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, (int)Integer.MIN_VALUE, (int)-64), BiomeFilter.biome())));
        context.register(BLOODCAP_PATCH_SURFACE, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.BLOODCAP_PATCH), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.register(HUGE_ARIA, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.HUGE_ARIA_MUSHROOM), List.of(RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome(), PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get())))));
        context.register(LIMESTONE_BLOB_SWAMP, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.LIMESTONE_BLOB), List.of(InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome())));
        context.register(LIMESTONE_BLOB_MARSH, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.LIMESTONE_BLOB), List.of(InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome())));
        context.register(MUD_BLOB, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.MUD_BLOB), List.of(PlacementUtils.countExtra((int)2, (float)0.5f, (int)1), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)2), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome())));
        context.register(MUD_PATCH_SWAMP, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.MUD_PATCH), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.register(MUD_PATCH_MARSH, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.MUD_PATCH), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.register(MUD_POOL_SWAMP, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.MUD_POOL), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.register(MUD_POOL_MARSH, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.MUD_POOL), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.register(SUPER_THICK_CORDGRASS_PATCH, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WetlandWhimsyConfiguredFeatures.CORDGRASS_PATCH), WetlandWhimsyPlacedFeatures.marshFoliagePlacement()));
        context.register(FERN_CLONE_CAUSE_FUCK_THE_FEATURE_CYCLE, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(VegetationFeatures.PATCH_LARGE_FERN), List.of(RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome())));
    }

    public static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)WetlandWhimsy.rLoc(name));
    }

    public static List<PlacementModifier> bogTreePlacement() {
        return List.of(PlacementUtils.countExtra((int)2, (float)0.5f, (int)3), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)2), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome(), PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get())));
    }

    public static List<PlacementModifier> marshTreePlacement() {
        return List.of(CountPlacement.of((int)2), RarityFilter.onAverageOnceEvery((int)7), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome(), PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get())));
    }

    public static List<PlacementModifier> foliagePlacement() {
        return List.of(PlacementUtils.HEIGHTMAP_WORLD_SURFACE, CountPlacement.of((int)3), RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.filteredByBlockSurvival((Block)Blocks.SHORT_GRASS), BiomeFilter.biome());
    }

    public static List<PlacementModifier> marshFoliagePlacement() {
        return List.of(PlacementUtils.countExtra((int)17, (float)0.5f, (int)6), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)2), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome(), PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get())));
    }
}

