/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.datagen.loot;

import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyItems;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyLoot;
import uwu.juni.wetland_whimsy.datagen.loot.WetlandWhimsyEntityLoot;

@ParametersAreNonnullByDefault
public class WetlandWhimsyMiscLoot
implements LootTableSubProvider {
    public static final ResourceKey<LootTable> BASIC_LOOT = WetlandWhimsyMiscLoot.createKey("basic_loot");
    public static final ResourceKey<LootTable> INTERMEDIATE_LOOT = WetlandWhimsyMiscLoot.createKey("intermediate_loot");
    public static final ResourceKey<LootTable> EPIC_LOOT = WetlandWhimsyMiscLoot.createKey("epic_loot");
    public static final ResourceKey<LootTable> ANCIENT_COIN = WetlandWhimsyMiscLoot.createKey("vault/ancient_coin");
    public static final ResourceKey<LootTable> BOILING_INCENSE = WetlandWhimsyMiscLoot.createKey("incense/boiling");
    public static final ResourceKey<LootTable> BRINE_INCENSE = WetlandWhimsyMiscLoot.createKey("incense/brine");
    public static final ResourceKey<LootTable> ROT_INCENSE = WetlandWhimsyMiscLoot.createKey("incense/rot");
    public static final ResourceKey<LootTable> WEBBED_INCENSE = WetlandWhimsyMiscLoot.createKey("incense/webbed");
    public static final ResourceKey<LootTable> SWAMP_SPIDER_SHEARED = WetlandWhimsyMiscLoot.createKey("entities/swamp_spider_sheared");
    public static final ResourceKey<LootTable> SWAMP_SPIDER_SHEARING = WetlandWhimsyMiscLoot.createKey("entities/swamp_spider_shearing");

    static ResourceKey<LootTable> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)WetlandWhimsy.rLoc(name));
    }

    public WetlandWhimsyMiscLoot(HolderLookup.Provider lookupProvider) {
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
        output.accept(BASIC_LOOT, WetlandWhimsyLoot.createBasicLootTable());
        output.accept(INTERMEDIATE_LOOT, WetlandWhimsyLoot.createIntermediateLootTable());
        output.accept(EPIC_LOOT, WetlandWhimsyLoot.createEpicLootTable());
        output.accept(BOILING_INCENSE, WetlandWhimsyLoot.createBoilingLootTable());
        output.accept(BRINE_INCENSE, WetlandWhimsyLoot.createBrineLootTable());
        output.accept(ROT_INCENSE, WetlandWhimsyLoot.createRotLootTable());
        output.accept(WEBBED_INCENSE, WetlandWhimsyLoot.createWebbedLootTable());
        output.accept(ANCIENT_COIN, WetlandWhimsyMiscLoot.table(WetlandWhimsyMiscLoot.item(WetlandWhimsyItems.ANCIENT_COIN, 1.0, 3.0)));
        output.accept(SWAMP_SPIDER_SHEARED, WetlandWhimsyEntityLoot.SWAMP_SPIDER_TABLE);
        output.accept(SWAMP_SPIDER_SHEARING, WetlandWhimsyMiscLoot.table(WetlandWhimsyMiscLoot.item(WetlandWhimsyBlocks.BLOODCAP_MUSHROOM, 1.0, 3.0)));
    }

    static LootTable.Builder table(LootPoolSingletonContainer.Builder<?> item) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add(item));
    }

    static LootPoolSingletonContainer.Builder<?> item(ItemLike item, double min, double max) {
        return LootItem.lootTableItem((ItemLike)item).apply(WetlandWhimsyLoot.lootCount((float)min, (float)max));
    }
}

