/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.datagen.loot;

import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.neoforged.neoforge.registries.DeferredBlock;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyItems;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyLoot;
import uwu.juni.wetland_whimsy.misc.WetlandWhimsyCompat;

public class WetlandWhimsyBlockLoot
extends BlockLootSubProvider {
    public WetlandWhimsyBlockLoot(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.DEFAULT_FLAGS, provider);
    }

    protected Iterable<Block> getKnownBlocks() {
        return WetlandWhimsyBlocks.BLOCKS.getEntries().stream().map(block -> (Block)block.value()).toList();
    }

    protected void generate() {
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_LOG);
        this.dropSelf(WetlandWhimsyBlocks.STRIPPED_BALD_CYPRESS_LOG);
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_WOOD);
        this.dropSelf(WetlandWhimsyBlocks.STRIPPED_BALD_CYPRESS_WOOD);
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING);
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS);
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_STAIRS);
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_SLAB);
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_FENCE);
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_FENCE_GATE);
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_TRAPDOOR);
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_BUTTON);
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_PRESSURE_PLATE);
        if (WetlandWhimsyCompat.FARMERS_DELIGHT) {
            this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_CABINET.get());
        }
        this.dropSelf(WetlandWhimsyBlocks.LIMESTONE);
        this.dropSelf(WetlandWhimsyBlocks.POLISHED_LIMESTONE);
        this.dropSelf(WetlandWhimsyBlocks.LIMESTONE_BRICKS);
        this.dropSelf(WetlandWhimsyBlocks.LIMESTONE_STAIRS);
        this.dropSelf(WetlandWhimsyBlocks.POLISHED_LIMESTONE_STAIRS);
        this.dropSelf(WetlandWhimsyBlocks.LIMESTONE_BRICK_STAIRS);
        this.dropSelf(WetlandWhimsyBlocks.LIMESTONE_SLAB);
        this.dropSelf(WetlandWhimsyBlocks.POLISHED_LIMESTONE_SLAB);
        this.dropSelf(WetlandWhimsyBlocks.LIMESTONE_BRICK_SLAB);
        this.dropSelf(WetlandWhimsyBlocks.LIMESTONE_WALL);
        this.dropSelf(WetlandWhimsyBlocks.POLISHED_LIMESTONE_WALL);
        this.dropSelf(WetlandWhimsyBlocks.LIMESTONE_BRICK_WALL);
        this.dropSelf(WetlandWhimsyBlocks.LIMESTONE_PILLAR);
        this.dropSelf(WetlandWhimsyBlocks.CORDGRASS_THATCH);
        this.dropSelf(WetlandWhimsyBlocks.BLOODCAP_MUSHROOM);
        this.dropSelf(WetlandWhimsyBlocks.ARIA_MUSHROOM);
        this.dropSelf(WetlandWhimsyBlocks.ARIA_SPORES);
        this.dropSelf(WetlandWhimsyBlocks.LIMESTONE_BRAZIER);
        this.dropSelf(WetlandWhimsyBlocks.SOUL_BRAZIER);
        this.add((Block)WetlandWhimsyBlocks.PENNYWORT.get(), this.createPetalsDrops((Block)WetlandWhimsyBlocks.PENNYWORT.get()));
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_SIGN);
        this.dropSelf(WetlandWhimsyBlocks.BALD_CYPRESS_HANGING_SIGN);
        this.dropOther((Block)WetlandWhimsyBlocks.BALD_CYPRESS_WALL_SIGN.get(), (ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_SIGN.get());
        this.dropOther((Block)WetlandWhimsyBlocks.BALD_CYPRESS_WALL_HANGING_SIGN.get(), (ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_HANGING_SIGN.get());
        this.dropShrooms(WetlandWhimsyBlocks.ARIA_MUSHROOM_BLOCK, WetlandWhimsyBlocks.ARIA_MUSHROOM);
        this.dropShrooms(WetlandWhimsyBlocks.BLOODCAP_MUSHROOM_BLOCK, WetlandWhimsyBlocks.BLOODCAP_MUSHROOM);
        this.add((Block)WetlandWhimsyBlocks.BALD_CYPRESS_DOOR.get(), this.createDoorTable((Block)WetlandWhimsyBlocks.BALD_CYPRESS_DOOR.get()));
        this.add((Block)WetlandWhimsyBlocks.BALD_CYPRESS_LEAVES.get(), this.createLeavesDrops((Block)WetlandWhimsyBlocks.BALD_CYPRESS_LEAVES.get(), (Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add((Block)WetlandWhimsyBlocks.CORDGRASS.get(), this.createCordgrassDrops(WetlandWhimsyBlocks.CORDGRASS));
        this.add((Block)WetlandWhimsyBlocks.POTTED_BALD_CYPRESS_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.asItem()));
        this.add((Block)WetlandWhimsyBlocks.POTTED_PENNYWORT.get(), this.createPotFlowerItemTable((ItemLike)WetlandWhimsyBlocks.PENNYWORT.asItem()));
        this.add((Block)WetlandWhimsyBlocks.POTTED_CORDGRASS.get(), this.createPotFlowerItemTable((ItemLike)WetlandWhimsyBlocks.CORDGRASS.asItem()));
        this.add((Block)WetlandWhimsyBlocks.POTTED_BLOODCAP_MUSHROOM.get(), this.createPotFlowerItemTable((ItemLike)WetlandWhimsyBlocks.BLOODCAP_MUSHROOM.asItem()));
        this.add((Block)WetlandWhimsyBlocks.POTTED_ARIA_MUSHROOM.get(), this.createPotFlowerItemTable((ItemLike)WetlandWhimsyBlocks.ARIA_MUSHROOM.asItem()));
        this.noDrop(WetlandWhimsyBlocks.SUSSY_MUD);
        this.noDrop(WetlandWhimsyBlocks.ANCIENT_BRAZIER);
        this.noDrop(WetlandWhimsyBlocks.ANCIENT_POT);
    }

    LootTable.Builder createCordgrassDrops(DeferredBlock<?> block) {
        HolderLookup.RegistryLookup lookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference fortune = lookup.getOrThrow(Enchantments.FORTUNE);
        return this.createShearsDispatchTable((Block)block.get(), (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem(WetlandWhimsyItems.CARROT_SEEDS).when(LootItemRandomChanceCondition.randomChance((float)0.125f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)fortune, (int)2))));
    }

    void dropShrooms(DeferredBlock<?> block, DeferredBlock<?> shroom) {
        this.add((Block)block.get(), b -> LootTable.lootTable().withPool(LootPool.lootPool().when(this.hasSilkTouch()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))).withPool(LootPool.lootPool().when(this.hasSilkTouch().invert()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)shroom).apply(WetlandWhimsyLoot.lootCount(-6.0f, 2.0f)))));
    }

    void dropSelf(DeferredBlock<?> b) {
        this.dropSelf((Block)b.get());
    }

    void noDrop(DeferredBlock<?> b) {
        this.add((Block)b.get(), WetlandWhimsyBlockLoot.noDrop());
    }
}

