/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.items;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DaggerItem
extends Item {
    public DaggerItem(Item.Properties properties) {
        super(properties.component(DataComponents.TOOL, (Object)DaggerItem.createToolProperties()));
    }

    public static Tool createToolProperties() {
        return new Tool((List)ImmutableList.of((Object)Tool.Rule.minesAndDrops((List)ImmutableList.of((Object)Blocks.COBWEB), (float)15.0f), (Object)Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f)), 1.0f, 2);
    }

    public static ItemAttributeModifiers createAttributes(float damage, float speed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean canAttackBlock(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player) {
        return !player.isCreative();
    }

    public void postHurtEnemy(@Nonnull ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    public float getAttackDamageBonus(@Nonnull Entity target, float damage, @Nonnull DamageSource damageSource) {
        Vec3 pos1 = target.position();
        Vec3 pos2 = damageSource.getSourcePosition();
        if (pos2 == null) {
            return super.getAttackDamageBonus(target, damage, damageSource);
        }
        double dist = pos1.distanceTo(pos2);
        return 10.0f / (float)Math.max(dist - 0.33, 0.1);
    }
}

