/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.entities;

import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import uwu.juni.wetland_whimsy.datagen.loot.WetlandWhimsyMiscLoot;

public class SwampSpiderEntity
extends Spider {
    private static final EntityDataAccessor<Boolean> DATA_SHEARED = SynchedEntityData.defineId(SwampSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    static final String SHEARED_ID = "sheared";
    public final AnimationState idleAnimationState = new AnimationState();

    public SwampSpiderEntity(EntityType<? extends SwampSpiderEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(@Nonnull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SHEARED, (Object)false);
    }

    public void addAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean(SHEARED_ID, this.isSheared());
    }

    public void readAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSheared(compound.getBoolean(SHEARED_ID));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.375).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MAX_HEALTH, 20.0);
    }

    void setupAnimationStates() {
        this.idleAnimationState.startIfStopped(this.tickCount);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    public boolean doHurtTarget(@Nonnull Entity entity) {
        if (!super.doHurtTarget(entity)) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            int i;
            LivingEntity lEntity = (LivingEntity)entity;
            switch (this.level().getDifficulty()) {
                case NORMAL: {
                    int n = 3;
                    break;
                }
                case HARD: {
                    int n = 5;
                    break;
                }
                default: {
                    int n = i = 0;
                }
            }
            if (i > 0) {
                lEntity.addEffect(new MobEffectInstance(MobEffects.POISON, i * 20, 0), (Entity)this);
            }
        }
        return true;
    }

    protected Vec3 getPassengerAttachmentPoint(@Nonnull Entity entity, @Nonnull EntityDimensions dimensions, float partialTick) {
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTick).multiply(1.0, 0.5, 1.0);
    }

    protected InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.isSheared() || !this.isAlive() || !itemstack.is(Tags.Items.TOOLS_SHEAR)) {
            return super.mobInteract(player, hand);
        }
        this.level().playSound(player, player.blockPosition(), SoundEvents.BOGGED_SHEAR, SoundSource.PLAYERS);
        this.setSheared(true);
        this.spawnShearedMushrooms();
        this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
        if (!this.level().isClientSide) {
            itemstack.hurtAndBreak(1, (LivingEntity)player, SwampSpiderEntity.getSlotForHand((InteractionHand)hand));
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(DATA_SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.entityData.set(DATA_SHEARED, (Object)sheared);
    }

    void spawnShearedMushrooms() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        LootTable table = sLevel.getServer().reloadableRegistries().getLootTable(WetlandWhimsyMiscLoot.SWAMP_SPIDER_SHEARING);
        LootParams params = new LootParams.Builder(sLevel).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.SHEARING);
        for (ItemStack item : table.getRandomItems(params)) {
            this.spawnAtLocation(item, this.getBbHeight());
        }
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return this.isSheared() ? WetlandWhimsyMiscLoot.SWAMP_SPIDER_SHEARED : super.getDefaultLootTable();
    }
}

