/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.entities;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyEntityTypes;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyItems;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyParticleTypes;
import uwu.juni.wetland_whimsy.content.WetlandWhimsySounds;

public class SludgeChargeEntity
extends AbstractArrow {
    float oldvRot = 0.0f;
    float vRot = 0.0f;

    public SludgeChargeEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public SludgeChargeEntity(LivingEntity shooter, Level level) {
        super(WetlandWhimsyEntityTypes.SLUDGE_CHARGE.get(), shooter, level, new ItemStack((ItemLike)WetlandWhimsyItems.SLUDGE_CHARGE.get()), null);
    }

    public SludgeChargeEntity(Level level, double x, double y, double z) {
        super(WetlandWhimsyEntityTypes.SLUDGE_CHARGE.get(), x, y, z, level, new ItemStack((ItemLike)WetlandWhimsyItems.SLUDGE_CHARGE.get()), null);
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public float getVRot() {
        return this.vRot;
    }

    public float getOldVRot() {
        return this.oldvRot;
    }

    public boolean isGrounded() {
        return this.inGround;
    }

    protected void onHitEntity(@Nonnull EntityHitResult result) {
        Entity entity = result.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 5.0f);
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            ImmutableList effects = ImmutableList.of((Object)MobEffects.MOVEMENT_SLOWDOWN, (Object)MobEffects.BLINDNESS, (Object)MobEffects.POISON);
            for (Holder effect : effects) {
                le.addEffect(new MobEffectInstance(effect, 30, 1, false, false));
            }
        }
        this.doHit(result.getLocation());
        this.discard();
    }

    protected void onHitBlock(@Nonnull BlockHitResult result) {
        this.doHit(result.getBlockPos().getCenter());
        this.discard();
    }

    void doHit(Vec3 pos) {
        Level level = this.level();
        if (level.isClientSide) {
            return;
        }
        this.playSound((SoundEvent)WetlandWhimsySounds.SLUDGE_CHARGE_HIT.get(), 1.0f, (float)this.getRandom().nextInt(7, 13) / 10.0f);
        AreaEffectCloud cloud = new AreaEffectCloud(level, this.getX(), this.getY(), this.getZ());
        cloud.setParticle((ParticleOptions)WetlandWhimsyParticleTypes.MUD_DRIP.get());
        cloud.setRadius((float)Math.PI);
        cloud.setDuration(300);
        cloud.setRadiusPerTick(-0.01f);
        cloud.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 2));
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            cloud.setOwner(le);
        }
        level.addFreshEntity((Entity)cloud);
    }

    public void tick() {
        if (this.level() instanceof ClientLevel) {
            this.oldvRot = this.vRot;
            this.vRot += 10.0f;
        }
        if (this.inGround) {
            this.discard();
        }
        super.tick();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }
}

