/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.entities;

import com.google.common.collect.ImmutableList;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyEntityTypes;
import uwu.juni.wetland_whimsy.content.WetlandWhimsySounds;
import uwu.juni.wetland_whimsy.content.entities.goals.CraneFlyGoal;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyTags;

@ParametersAreNonnullByDefault
public class CraneEntity
extends Animal {
    public boolean befriended = false;
    static final String befriendedId = "befriended";
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState flyAnimationState = new AnimationState();

    public CraneEntity(EntityType<? extends CraneEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        ImmutableList goals = ImmutableList.of((Object)new FloatGoal((Mob)this), (Object)new LeapAtTargetGoal((Mob)this, 0.4f), (Object)new MeleeAttackGoal((PathfinderMob)this, 1.0, true), (Object)new PanicGoal((PathfinderMob)this, 1.2), (Object)new BreedGoal((Animal)this, 1.0), (Object)new TemptGoal((PathfinderMob)this, 1.0, item -> this.isFood((ItemStack)item), false), (Object)new FollowParentGoal((Animal)this, 1.1), (Object)new RandomStrollGoal((PathfinderMob)this, 1.0), (Object)((Object)new CraneFlyGoal(this)), (Object)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), (Object)new RandomLookAroundGoal((Mob)this));
        int priority = 0;
        for (Goal goal : goals) {
            this.goalSelector.addGoal(priority, goal);
            ++priority;
        }
        this.targetSelector.addGoal(priority, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true, e -> this.befriended));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.FALL_DAMAGE_MULTIPLIER, 0.25).add(Attributes.MOVEMENT_SPEED, 0.285).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 6.0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean(befriendedId, this.befriended);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains(befriendedId)) {
            this.befriended = compound.getBoolean(befriendedId);
        }
    }

    void setupAnimationStates() {
        if (!this.onGround() && !this.isInWater()) {
            this.idleAnimationState.stop();
            this.flyAnimationState.startIfStopped(this.tickCount);
        } else {
            this.flyAnimationState.stop();
            this.idleAnimationState.startIfStopped(this.tickCount);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    public void aiStep() {
        super.aiStep();
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0 && !this.hasEffect(MobEffects.SLOW_FALLING)) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.8, 1.0));
        }
    }

    public boolean isFood(ItemStack item) {
        return item.is(WetlandWhimsyTags.Items.CRANE_FOOD);
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)WetlandWhimsyEntityTypes.CRANE.get().create((Level)level);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        BiFunction<Player, InteractionHand, InteractionResult> fn = (x$0, x$1) -> super.mobInteract(x$0, x$1);
        if (!this.isFood(player.getItemInHand(hand))) {
            fn = (x$0, x$1) -> super.mobInteract(x$0, x$1);
        } else if (!this.befriended && !this.isBaby()) {
            fn = this::befriend;
        } else if (this.getHealth() < this.getMaxHealth()) {
            fn = this::heal;
        }
        return fn.apply(player, hand);
    }

    InteractionResult heal(Player player, InteractionHand hand) {
        FoodProperties props = player.getItemInHand(hand).getFoodProperties((LivingEntity)this);
        this.heal(props == null ? 4.0f : (float)(props.nutrition() * 2));
        this.feed(player, hand);
        return InteractionResult.SUCCESS;
    }

    InteractionResult befriend(Player player, InteractionHand hand) {
        this.befriended = true;
        this.feed(player, hand);
        this.sendParticles(ParticleTypes.HAPPY_VILLAGER, 10);
        return InteractionResult.SUCCESS;
    }

    void feed(Player player, InteractionHand hand) {
        this.usePlayerItem(player, hand, player.getItemInHand(hand));
        this.gameEvent((Holder)GameEvent.EAT);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() instanceof Player) {
            if (this.befriended) {
                this.sendParticles(ParticleTypes.ANGRY_VILLAGER, 3);
            }
            this.befriended = false;
        }
        return super.hurt(source, amount);
    }

    <T extends ParticleOptions> void sendParticles(T type, int amount) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        Vec3 pos = this.position();
        sLevel.sendParticles(type, pos.x, pos.y, pos.z, amount, 0.5, 1.0, 0.0, 0.0);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)WetlandWhimsySounds.CRANE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)WetlandWhimsySounds.CRANE_HIT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)WetlandWhimsySounds.CRANE_DEATH.get();
    }
}

